<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

$result = array();

//ポスト処理
if (isset($_POST)){

  //リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  //config.csvの値を取得
  $config = get_data_conf("../".PATH_CONF);

  //ノード取得
  $path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
  $path->get_path();

  $post = new extend_post_check($_POST,$file_data,$conf_msg);
  $post->check_multi_arr();

  //書き込み処理
  if($post->multi_arr_error_flg()){

    //書き込み行生成＆書き込み
    $line = "";
    for($i = 0; $i < count($_POST["file_body"]); $i++) {
      $body = convert_enc($post->data["file_body"]["value"][$i],"shift_jis");
      $name = convert_enc($post->data["file_name"]["value"][$i],"shift_jis");
      $dir  = convert_enc($post->data["folder_dir"]["value"][$i],"shift_jis");
      $line .= "\"".$dir."\",\"".$name."\",\"".$body."\"\n";
    }
    write_data($path->csv_files,$line);

    //$_POSTを初期化
    unset($_POST);

    $result["result"] = 1;

  } else {
    $result["result"] = 0;
  }
} else {
  $result["result"] = 0;
}


//XML START
$xml = new post_result_xml($result,$post->data,$file_data);
$xml->result_arr_xml();
//XML END


?>