<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

$result = array("filepath" => "","type" => "","dir" => "","file" => "","flg" => "","result" => "");

//ポスト処理
if (isset($_POST)){

  //リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  //config.csvの値を取得
  $config = get_data_conf("../".PATH_CONF);

  //ノード取得
  $path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
  $path->get_path();

  $node = new item_node($path->dir_name,$path->dir_path,$path->csv_dir,$path->csv_files,$config["allow_tag"]);

  $post = new extend_post_check($_POST,$file_data,$conf_msg);

  $tmp_name = $_FILES["file_image"]["tmp_name"];
  $name     = $_FILES["file_image"]["name"];

  //入力チェック１（folder_dir）
  if (isset($_POST["folder_dir"])) {
    $post->data["folder_dir"]["value"] = html_spc($_POST["folder_dir"]); //エスケープ処理

    $post->error["folder_dir"] = false;
    foreach($node->dir as $i => $dir){
      if($dir["dir"] === $post->data["folder_dir"]["value"]){
        $post->error["folder_dir"] = true;
        $result["dir"] = $dir["dir"];
      }
    }
    $post->data["folder_dir"]["error"] = ($post->error["folder_dir"])? "": $conf_msg_extends["folder_failed"];

  } else {
    $post->error["folder_dir"] = false;
    $post->data["folder_dir"]["error"] = $conf_msg_extends["folder_none"];
  }

  //入力チェック２（file_image）
  if (is_uploaded_file($tmp_name)) {
    $post->data["file_image"]["value"] = html_spc($name); //エスケープ処理

    list($w,$h,$result["type"],) = getimagesize($tmp_name);
    if ($result["type"] != null && $result["type"] < 4){
      if (strlen($name) == mb_strlen($name)){
        $post->error["file_image"] = true;
        $post->data["file_image"]["error"] = "";
      } else {
        $post->error["file_image"] = false;
        $post->data["file_image"]["error"] = $conf_msg_extends["file_kind"];
      }
      //} else {
      //  $post->error["file_image"] = true;
      //  $post->data["file_image"]["error"] = "";
      //  $name = convert_enc($name);
      //}
    } else {
      $post->error["file_image"] = false;
      $post->data["file_image"]["error"] = $conf_msg_extends["file_type"];
    }

  } else {
    $post->error["file_image"] = false;
    $post->data["file_image"]["error"] = $conf_msg_extends["file_none"];
  }

  //入力チェック３（file_body）
  $post->check_single("file_body");

  //入力チェック４（file_imageの重複）
  $post->data["file_flg"]["value"] = html_spc($_POST["file_flg"]); //エスケープ処理
  $post->error["file_flg"] = $post->data["file_flg"]["value"];
  $result["flg"]  = 0;
  $result["file"] = 0;
  if($post->error["file_image"] && $post->error["folder_dir"] && $post->error["file_body"]){
    foreach($node->dir as $i => $dir){
      if($dir["dir"] === $post->data["folder_dir"]["value"]){
        foreach($dir["file"] as $j => $file){
          if($file["name"] === $name){
            if($post->error["file_flg"]) {
              $post->error["file_image"] = false;
              $post->data["file_image"]["error"] = $conf_msg_extends["file_dupli"];
              $result["flg"] = 1;
              $result["file"] = $j;
            } else {
              $result["file"] = $j;
            }
            break 2;
          }
        }
      }
    }
  }

  //アップロード処理
  if($post->error["file_image"] && $post->error["folder_dir"] && $post->error["file_body"]){

    //ファイルアップロード
    $result["filepath"] = $path->dir_name."/".$post->data["folder_dir"]["value"]."/".$name;
    move_uploaded_file($tmp_name, "../".$result["filepath"]);

    //書き込み行生成＆書き込み
    $line = "";
    foreach($node->dir as $i => $dir){
      foreach($dir["file"] as $j => $file){
        if($dir["dir"] === $post->data["folder_dir"]["value"] && $file["name"] === $name && $post->data["file_body"]["value"] !== ""){
	        $l_dir  = convert_enc($post->data["folder_dir"]["value"],"shift_jis");
	        $l_name = convert_enc($name,"shift_jis");
	        $l_body = convert_enc($post->data["file_body"]["value"],"shift_jis");
	        $line .= "\"".$l_dir."\",\"".$l_name."\",\"".$l_body."\"\n";
        } else {
	        $l_dir  = convert_enc($dir["dir"],"shift_jis");
	        $l_name = convert_enc($file["name"],"shift_jis");
	        $l_body = convert_enc(str_replace("<br />","",$file["body"]),"shift_jis");
	        $line .= "\"".$l_dir."\",\"".$l_name."\",\"".$l_body."\"\n";
	      }
      }
    }

    $newline = "";
    if($post->error["file_flg"]) {
      $nl_dir  = convert_enc($post->data["folder_dir"]["value"],"shift_jis");
      $nl_name = convert_enc($name,"shift_jis");
      $nl_body = convert_enc($post->data["file_body"]["value"],"shift_jis");
      $newline .= "\"".$nl_dir."\",\"".$nl_name."\",\"".$nl_body."\"\n";
    }

    //list-files.csv書き込み
    write_data($path->csv_files,$line,$newline);

    $result["result"] = 1;

  } else {
    $result["result"] = 0;
  }
} else {
  $result["result"] = 0;
}


//XML START
$xml = new post_result_xml($result,$post->data,$file_data);
$xml->result_val_xml();
//XML END


?>