<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

$result = array();

//ポスト処理
if (isset($_POST)){

  //リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  //config.csvの値を取得
  $config = get_data_conf("../".PATH_CONF);

  //ノード取得
  $path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
  $path->get_path();

  $node = new item_node($path->dir_name,$path->dir_path,$path->csv_dir,$path->csv_files,$config["allow_tag"]);

  $post = new extend_post_check($_POST,$folder_data,$conf_msg);
  $post->check_multi_arr();

  //書き込み処理
  if($post->multi_arr_error_flg()){

    //書き込み行生成＆書き込み
    $line = "";
    foreach($node->dir as $i => $dir){
      $dir  = convert_enc($post->data["folder_dir"]["value"][$i],"shift_jis");
      $name = convert_enc($post->data["folder_name"]["value"][$i],"shift_jis");
      $pub  = convert_enc($post->data["folder_pub"]["value"][$i],"shift_jis");
      $line .= "\"".$dir."\",\"".$name."\",\"".$pub."\"\n";
    }
    //list-folder.csv書き込み
    write_data($path->csv_dir,$line);

    //$_POSTを初期化
    unset($_POST);

    $result["result"] = 1;

  } else {
    $result["result"] = 0;
  }
} else {
  $result["result"] = 0;
}


//XML START
$xml = new post_result_xml($result,$post->data,$folder_data);
$xml->result_arr_xml();
//XML END


?>