<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

$result = array();

//ポスト処理
if (isset($_POST)) {

  //リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  //config.csvの値を取得
  $config = get_data_conf("../".PATH_CONF);

  //ノード取得
  $path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
  $path->get_path();

  $node = new item_node($path->dir_name,$path->dir_path,$path->csv_dir,$path->csv_files,$config["allow_tag"]);

  $post = new extend_post_check($_POST,$folder_data,$conf_msg);
  $post->check_multi_val();

  if (!isset($_POST["folder_pub"])) {
    $post->data["folder_pub"]["value"] = 0;
    $post->data["folder_pub"]["flg"]   = true;
    $post->data["folder_pub"]["error"] = "";
  }

  //folder_dirの重複
  if($post->data["folder_dir"]["flg"] == true){
    foreach($node->dir as $dir){
      if($dir["dir"] === $post->data["folder_dir"]["value"]){
        $post->data["folder_dir"]["flg"] = false;
        $post->data["folder_dir"]["error"] = $conf_msg_extends["folder_dupli"];
        break;
      }
    }
  }

  //書き込み処理
  if($post->multi_val_error_flg()){

    //フォルダ生成
    mkdir($path->dir_path.$post->data["folder_dir"]["value"],0755);

    //書き込み行生成＆書き込み
    $line = "";
    foreach($node->dir as $dir){
      $l_dir  = convert_enc($dir["dir"],"shift_jis");
      $l_name = convert_enc($dir["name"],"shift_jis");
      $l_pub  = convert_enc($dir["pub"],"shift_jis");
      $line .= "\"".$l_dir."\",\"".$l_name."\",\"".$l_pub."\"\n";
    }
    $newline = "";
    $nl_dir  = convert_enc($post->data["folder_dir"]["value"],"shift_jis");
    $nl_name = convert_enc($post->data["folder_name"]["value"],"shift_jis");
    $nl_pub  = convert_enc($post->data["folder_pub"]["value"],"shift_jis");
    $newline .= "\"".$nl_dir."\",\"".$nl_name."\",\"".$nl_pub."\"\n";

    //list-folder.csv書き込み
    write_data($path->csv_dir,$line,$newline);

    $result["result"] = 1;

  } else {
    $result["result"] = 0;
  }
} else {
  $result["result"] = 0;
}


//XML START
$xml = new post_result_xml($result,$post->data,$folder_data);
$xml->result_val_xml();
//XML END


?>