<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

$result    = array("result" => "");
$error     = array("folder_dir" => "","folder_pub" => "");
$post_data = array("folder_dir" => "","folder_pub" => "");

//ポスト処理
if (isset($_POST)){

  //リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  //config.csvの値を取得
  $config = get_data_conf("../".PATH_CONF);
  //ノード取得
  $path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
  $path->get_path();

  $node = new item_node($path->dir_name,$path->dir_path,$path->csv_dir,$path->csv_files,$config["allow_tag"]);

  $num;

  //入力チェック１（folder_dir）
  if (isset($_POST["folder_dir"])) {
    $post_data["folder_dir"]["value"] = html_spc($_POST["folder_dir"]); //エスケープ処理

    $error["folder_dir"] = false;
    foreach($node->dir as $i => $dir){
      if($dir["dir"] === $post_data["folder_dir"]["value"]){
        $num = $i;
        $error["folder_dir"] = true;
      }
    }
    $post_data["folder_dir"]["error"] = ($error["folder_dir"])? "": $conf_msg_extends["folder_failed"];

  } else {
    $error["folder_dir"] = false;
    $post_data["folder_dir"]["error"] = $conf_msg_extends["folder_none"];
  }

  //入力チェック２（folder_pub）
  if (isset($_POST["folder_pub"])) {
    $post_data["folder_pub"]["value"] = html_spc($_POST["folder_pub"]); //エスケープ処理

    $error["folder_pub"] = false;
    if($post_data["folder_pub"]["value"] == 0 || $post_data["folder_pub"]["value"] == 1){
      $error["folder_pub"] = true;
    }
    $post_data["folder_pub"]["error"] = ($error["folder_pub"])? "": $conf_msg_extends["pub_failed"];

  } else {
    $error["folder_pub"] = false;
    $post_data["folder_pub"]["error"] = $conf_msg_extends["pub_none"];
  }

  //公開設定変更
  if($error["folder_dir"] && $error["folder_pub"]){

    //書き込み行生成＆書き込み
    $data_dir = get_data_dir($path->csv_dir);
    $line = "";
    foreach($data_dir as $key => $item){
      if($item["dir"] !== $post_data["folder_dir"]["value"]){
        $l_dir  = convert_enc($item["dir"],"shift_jis");
        $l_name = convert_enc($item["name"],"shift_jis");
        $l_pub  = convert_enc($item["pub"],"shift_jis");
        $line .= "\"".$l_dir."\",\"".$l_name."\",\"".$l_pub."\"\n";
      } else {
        $nl_dir  = convert_enc($item["dir"],"shift_jis");
        $nl_name = convert_enc($item["name"],"shift_jis");
        $nl_pub  = ($item["pub"] == 0)? 1: 0;
        $nl_pub  = convert_enc($nl_pub,"shift_jis");
        $line .= "\"".$nl_dir."\",\"".$nl_name."\",\"".$nl_pub."\"\n";
      }
    }
    //list-files.csv書き込み
    write_data($path->csv_dir,$line);

    $result["result"] = 1;

  } else {
    $result["result"] = 0;
  }
} else {
  $result["result"] = 0;
}


//XML START
$xml = new post_result_xml($result,$post_data);
$xml->result_val_xml();
//XML END


?>
