<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

$result    = array("result" => "");

$tmp_name  = "";
$name      = "";

//ポスト処理
if (isset($_POST)) {

  //リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  //config.csvの値を取得
  $config = get_data_conf("../".PATH_CONF);

  //ノード取得
  $path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
  $path->get_path();

  $node = new item_node($path->dir_name,$path->dir_path,$path->csv_dir,$path->csv_files,$config["allow_tag"]);

  $post = new extend_post_check($_POST,$folder_data,$conf_msg);

  //入力チェック１（file_zipアップロード）
  if(is_uploaded_file($_FILES["file_zip"]["tmp_name"])){
    $tmp_name = $_FILES["file_zip"]["tmp_name"];
    $name     = $_FILES["file_zip"]["name"];
    if (Eregi('zip$', $name)){
      $post->error["file_zip"] = true;
      $post->data["file_zip"]["value"] = $name;
      $post->data["file_zip"]["error"] = "";
    } else {
      $post->error["file_zip"] = false;
      $post->data["file_zip"]["error"] = $conf_msg_extends["archive_type"];
    }
  } else {
    $post->error["file_zip"] = false;
    $post->data["file_zip"]["error"] = $conf_msg_extends["file_none"];
  }

  //入力チェック２（folder_dir）
  if ($post->error["file_zip"]) {
    $value = html_spc(preg_replace("/^(.+?)\.zip/","\\1", $name)); //エスケープ処理

    $post->data["folder_dir"]["flg"]    = array();
    $post->data["folder_dir"]["error"]  = "";
    $post->data["folder_dir"]["value"]  = $value;

    //チェッククラス開始
    $post_check = new post_check($value,$folder_data["folder_dir"],$conf_msg);
    foreach ($post_check->arr as $arr) {
      $post_check->err_flg($arr);
      $post->data["folder_dir"]["flg"][$arr] = $post_check->flg;
    }
    $post_check->err_msg($post->data["folder_dir"]["flg"]);
    $post->error["folder_dir"] = chk_post_error_val($post->data["folder_dir"]["flg"]);
    $post->data["folder_dir"]["error"] = $post_check->msg;
  }

  //入力チェック３（folder_name）
  $post->check_single("folder_name");

  //入力チェック４（folder_pub）
  $post->check_single("folder_pub");
  if (!isset($_POST["folder_pub"])) {
    $post->error["pub"] = true;
    $post->data["folder_pub"]["value"] = 0;
    $post->data["folder_pub"]["error"] = "";
  }

  //入力チェック５（folder_dirの重複）
  if($post->error["folder_dir"]){
    foreach($node->dir as $dir){
      if($dir["dir"] === $post->data["folder_dir"]["value"]){
        $post->error["folder_dir"] = false;
        $post->data["folder_dir"]["error"] = $conf_msg_extends["folder_dupli"];
      }
    }
  }

  //書き込み処理
  if($post->error["folder_dir"] && $post->error["folder_name"] && $post->error["folder_pub"] && $post->error["file_zip"]){

    //zipファイルアップロード
    $filepath = $path->dir_path.$name;
    move_uploaded_file($tmp_name, $filepath);

    $zip = new ZipArchive;
    if ($zip->open($filepath) === true) {
      mkdir($path->dir_path.$post->data["folder_dir"]["value"]);
		  for($i = 0; $i < $zip->numFiles; $i++) {
		    $upname = $zip->getNameIndex($i);
		    $upinfo = pathinfo($upname);
		    if(preg_match('#\.(jpeg|jpg|gif|png)$#i', $upname)) {
		      $uppath   = "zip://".dirname(dirname(__FILE__))."/".PATH_DIR_DIR."/".$post->data["file_zip"]["value"].'#'.$upname;
		      $copypath = $path->dir_path.$post->data["folder_dir"]["value"]."/".$upinfo['basename'];
		      copy($uppath, $copypath);
		    }
			}
      $zip->close();
    }
    unlink($filepath); //zipファイル削除

    //書き込み行生成＆書き込み
    $line = "";
    foreach($node->dir as $dir){
      $l_dir  = convert_enc($dir["dir"],"shift_jis");
      $l_name = convert_enc($dir["name"],"shift_jis");
      $l_pub  = convert_enc($dir["pub"],"shift_jis");
      $line .= "\"".$l_dir."\",\"".$l_name."\",\"".$l_pub."\"\n";
    }
    $newline = "";
    $nl_dir  = convert_enc($post->data["folder_dir"]["value"],"shift_jis");
    $nl_name = convert_enc($post->data["folder_name"]["value"],"shift_jis");
    $nl_pub  = convert_enc($post->data["folder_pub"]["value"],"shift_jis");
    $newline .= "\"".$nl_dir."\",\"".$nl_name."\",\"".$nl_pub."\"\n";
    //list-folder.csv書き込み
    write_data($path->csv_dir,$line,$newline);

    $result["result"] = 1;

  } else {
    $result["result"] = 0;
  }
} else {
  $result["result"] = 0;
}


//XML START
$xml = new post_result_xml($result,$post->data);
$xml->result_val_xml();
//XML END


?>