<?php

// バリデーションチェック
class post_check {

  var $value = "";
  var $item = array();
  var $txt = array();
  var $flg = "";
  var $msg = "";
  var $arr = array("must","kind","leng","min","max","chk");
  var $arr_kind = array("num","email","tel","text","text_h","text_k","text_s","text_p");

  // コンストラクタ
  function post_check($value,$item,$conf_msg) {
    $this->value = $value;
    $this->item  = $item;
    $this->txt   = $conf_msg;
  }

  // メンバメソッド(public)
  public function arr() {
    $this->arr;
  }

  public function arr_kind() {
    $this->arr_kind;
  }

  public function err_msg($temp_err) {
    $this->msg = "";
    if ($temp_err["must"]) {
      if ($this->value !== "") {
        $temp_msg  .= $this->txt[$this->item["kind"]];
        if (!$temp_err["kind"]) {
          if ($this->item["leng"] !== "" || !$temp_err["leng"]) {
            $this->msg .= $this->item["leng"].$this->txt["leng"].$temp_msg;
          } elseif ($this->item["min"] !== "" || !$temp_err["min"]) {
            $this->msg .= $this->item["min"].$this->txt["min"].$temp_msg;
          } elseif ($this->item["max"] !== "" || !$temp_err["max"]) {
            $this->msg .= $this->item["max"].$this->txt["max"].$temp_msg;
          } else {
            $this->msg .= $temp_msg;
          }
        } elseif (!$temp_err["leng"]) {
          $this->msg .= $this->item["leng"].$this->txt["leng"].$temp_msg;
        } elseif (!$temp_err["min"]) {
          $this->msg .= $this->item["min"].$this->txt["min"].$temp_msg;
        } elseif (!$temp_err["max"]) {
          $this->msg .= $this->item["max"].$this->txt["max"].$temp_msg;
        }
      }
    } else {
      $this->msg .= $this->txt["must"];
    }
  }

  public function err_flg($val) {
    // (エラー判定)必須項目
    if ($val == "must") {
      if ($this->item["must"]) {
        $this->flg = $this->must();
      } else {
        $this->flg = true;
      }
    // (エラー判定)種別
    } elseif ($val == "kind") {
      if($this->item["must"] || $this->value !== "") {
        switch($this->item["kind"]){
          case "num";
            $this->flg = $this->num();
            break;
          case "email";
            $this->flg = $this->email();
            break;
          case "tel";
            $this->flg = $this->tel();
            break;
          case "text_h";
            $this->flg = $this->text_h();
            break;
          case "text_k";
            $this->flg = $this->text_k();
            break;
          case "text_s";
            $this->flg = $this->text_s();
            break;
          case "text_p";
            $this->flg = $this->text_p();
            break;
          default;
            $this->flg = true;
        }
      }
    // (エラー判定)文字列長
    } elseif ($val == "leng") {
      if($this->item["must"] || $this->value !== "") {
        if($this->item["leng"] !== ""){
          $this->flg = $this->str_leng();
        } else {
          $this->flg = true;
        }
      }
    // (エラー判定)最小文字長
    } elseif ($val == "min") {
      if($this->item["must"] || $this->value !== "") {
        if($this->item["min"] !== ""){
          $this->flg = $this->str_min();
        } else {
          $this->flg = true;
        }
      }
    // (エラー判定)最大文字長
    } elseif ($val == "max") {
      if($this->item["must"] || $this->value !== "") {
        if($this->item["max"] !== ""){
          $this->flg = $this->str_max();
        } else {
          $this->flg = true;
        }
      }
    // (エラー判定)確認用※ここでは全てtrue
    } elseif ($val == "chk") {
      $this->flg = true;
    }
  }

  // メンバメソッド(private)
  // (入力チェック)必須項目
  private function must(){
    if($this->value !== ""){
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)半角数字
  private function num(){
    if(is_numeric($this->value)){
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)メールアドレス（半角英数字と@/_/-/.）
  private function email(){
    if (preg_match("/^([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+$/",$this->value)) {
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)電話番号（半角数字と半角ハイフン）
  private function tel(){
    if(preg_match("/^[0-9,-]+$/",$this->value)) {
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)全角日本語
  private function text_n(){
    if(preg_match("/(?:\xEF\xBD[\xA1-\xBF]|\xEF\xBE[\x80-\x9F])|[\x20-\x7E]/",$this->value)) {
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)全角ひらがな
  private function text_h(){
    if(preg_match("/^[ぁ-ん]+$/u",$this->value)) {
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)全角カタカナ
  private function text_k(){
    if(preg_match("/^[ァ-ヶー]+$/u",$this->value)) {
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)半角英数字
  private function text_s(){
    if(preg_match("/^[a-zA-Z0-9,-,_]+$/",$this->value)) {
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)パス
  private function text_p(){
    if(preg_match("/^[-_.!~*\'()a-zA-Z0-9;\/?:\@&=+\$,%#]+$/",$this->value)) {
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)文字列長
  private function str_leng(){
    if($this->item["leng"] == mb_strlen($this->value)){
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)最小文字長
  private function str_min(){
    if($this->item["min"] <= mb_strlen($this->value)){
      return true;
    } else {
      return false;
    }
  }
  // (入力チェック)最大文字長
  private function str_max(){
    if($this->item["max"] >= mb_strlen($this->value)){
      return true;
    } else {
      return false;
    }
  }

} //END post_check



//バリデーションチェック継承
class extend_post_check extends post_check {

  var $post  = "";
  var $data  = array();
  var $error = array();
  var $conf  = array();
  var $txt   = array();

  // コンストラクタ
  function extend_post_check($post,$conf_data,$conf_msg) {
    $this->post  = $post;
    $this->data  = array();
    $this->error = array();
    $this->conf  = $conf_data;
    $this->txt   = $conf_msg;
  }

  // メンバメソッド(regist)
  public function check_regist($account) {
    foreach ($this->conf as $name => $conf) {
      //未セットの場合は空の値をセット
      $value = (isset($this->post[$name]))? $this->post[$name]: "";

      //配列を連結
      if(is_array($value)){
        $value = $this->val_marge($value,",");
      } else {
        $value = $value;
      }

      $value = $this->html_spc($value); //エスケープ処理

      $this->data[$name]["flg"]   = array();
      $this->data[$name]["error"] = "";
      $this->data[$name]["value"] = $value;

      if($value !== ""){
        $value = ($name == "pass")? md5($value): $value;
        if($value === $account[$name]){
          $this->data[$name]["flg"] = true;
        } else {
          $this->data[$name]["flg"] = false;
          $this->data[$name]["error"] = $conf["name"].$this->txt["failed"];
        }
      } else {
        $this->data[$name]["flg"] = false;
        $this->data[$name]["error"] = $conf["name"].$this->txt["must"];
      }
    }
  }

  public function regist_flg() {
    $flg = true;
    foreach ($this->data as $name => $value) {
      if($value["flg"] == false){
        $flg = false;
        break;
      }
    }
    return $flg;
  }

  // メンバメソッド(check_single)
  public function check_single($name) {
    //未セットの場合は空の値をセット
    $value = (isset($this->post[$name]))? $this->post[$name]: "";

    //配列を連結
    if(is_array($value)){
      $value = $this->val_marge($value,",");
    } else {
      $value = $value;
    }

    $value = $this->html_spc($value); //エスケープ処理

    $this->data[$name]["flg"]   = array();
    $this->data[$name]["error"] = "";
    $this->data[$name]["value"] = $value;

    //チェッククラス開始
    $this->value = $value;
    $this->item  = $this->conf[$name];
    foreach ($this->arr as $arr) {
      $this->err_flg($arr);
      $this->data[$name]["flg"][$arr] = $this->flg;
    }
    $this->err_msg($this->data[$name]["flg"]);
    $this->data[$name]["error"] = $this->msg;

    $this->error[$name] = $this->single_error($this->data[$name]["flg"]);
  }

  private function single_error($value) {
    $flg = true;
    if(is_array($value)){
      foreach($value as $key => $val){
        if($val == false){
          $flg = false;
          break;
        }
      }
    } else {
      if($value == false){
        $flg = false;
      }
    }
    return $flg;
  }

  // メンバメソッド(check_multi_val)
  public function check_multi_val() {
    foreach ($this->conf as $name => $conf) {
      //未セットの場合は空の値をセット
      $value = (isset($this->post[$name]))? $this->post[$name]: "";

      //配列を連結
      if(is_array($value)){
        $value = $this->val_marge($value,",");
      } else {
        $value = $value;
      }

      $value = $this->html_spc($value); //エスケープ処理

      $this->data[$name]["flg"]   = array();
      $this->data[$name]["error"] = "";
      $this->data[$name]["value"] = $value;

      //チェッククラス開始
      $this->value = $value;
      $this->item  = $this->conf[$name];
      foreach ($this->arr as $arr) {
        $this->err_flg($arr);
        $this->data[$name]["flg"][$arr] = $this->flg;
      }
      $this->err_msg($this->data[$name]["flg"]);
      $this->data[$name]["error"] = $this->msg;
    }

    //二回入力確認
    foreach ($this->conf as $name => $conf) {
      if ($conf["chk"] !== "") {
        $temp_chk = $conf["chk"];
        if ($this->data[$name]["value"] === $this->data[$temp_chk]["value"]) {
          $this->data[$name]["flg"]["chk"] = true;
        } else {
          $this->data[$name]["flg"]["chk"] = false;
          $this->data[$name]["error"] = $conf_msg["chk"];
        }
      } else {
        $this->data[$name]["flg"]["chk"] = true;
      }
    }

    foreach ($this->conf as $name => $conf) {
      $this->error[$name] = $this->multi_val_error($this->data[$name]["flg"]);
    }
  }

  public function multi_val_error_flg() {
    $flg = true;
    foreach ($this->data as $name => $value) {
      if($this->error[$name] == false){
        $flg = false;
        break;
      }
    }
    return $flg;
  }

  private function multi_val_error($value) {
    $flg = true;
    if(is_array($value)){
      foreach($value as $key => $val){
        if($val == false){
          $flg = false;
          break;
        }
      }
    } else {
      if($value == false){
        $flg = false;
      }
    }
    return $flg;
  }

  // メンバメソッド(check_multi_arr)
  public function check_multi_arr() {
    foreach ($this->conf as $name => $conf) {
      if (isset($this->post[$name])){
        foreach($this->post[$name] as $key => $value) {
          $value = $this->html_spc($value); //エスケープ処理

          $this->data[$name]["flg"][$key]   = array();
          $this->data[$name]["error"][$key] = "";
          $this->data[$name]["value"][$key] = $value;

          //チェッククラス開始
          $this->value = $value;
          $this->item  = $this->conf[$name];
          foreach ($this->arr as $arr) {
            $this->err_flg($arr);
            $this->data[$name]["flg"][$key][$arr] = $this->flg;
          }
          $this->err_msg($this->data[$name]["flg"][$key]);
          $this->data[$name]["error"][$key] = $this->msg;
        }
        $this->error[$name] = $this->multi_arr_error($this->data[$name]["flg"]);
      }
    }
  }

  public function multi_arr_error_flg() {
    $flg = true;
    foreach ($this->conf as $name => $conf) {
      if($this->error[$name] == false){
        $flg = false;
        break;
      }
    }
    return $flg;
  }

  private function multi_arr_error($value) {
    $flg = true;
    foreach($value as $key1 => $val1){
      foreach($val1 as $key2 => $val2){
        if($val2 == false){
          $flg = false;
          break 2;
        }
      }
    }
    return $flg;
  }

  //htmlspecialchars
  private function html_spc($str){
    if(is_array($str)){
      return array_map("h",$str);
    } else {
      $str = stripslashes($str); //バックスラッシュを排除
      $str = htmlspecialchars($str,ENT_QUOTES);
      return $str;
    }
    return false;
  }

  //0をFALSEではなく数値文字列として評価する
  private function val_def($value) {
    if(is_array($value)){
      return(count($value));
    } elseif($value != ""){
      return 1;
    } else {
      return 0;
    }
  }

  //値が配列の場合は結合する
  private function val_marge($values, $item = "") {
    if(is_array($values)){
      $i = 0;
      $obj = "";
      $item = ($item !== "")? $item: ",";
      foreach($values as $value){
        $str = ($i == 0)? "": $item;
        $obj .= $str.$value;
        $i++;
      }
      return $obj;
    }
    return false;
  }

} //END extend_post_check



//リザルト出力（XML形式）
class post_result_xml {

  var $result = array();
  var $data   = array();
  var $xml    = stdClass;

  // コンストラクタ
  function post_result_xml($result,$data,$conf_data = array()) {
    $this->result = $result;
    $this->data   = $data;
    $this->conf   = $conf_data;
    $this->xml    = $xml;
  }

  // メンバメソッド(val)
  public function result_val_xml() {
    $this->result_head();
    $this->result_res();
    $this->result_val_main();
    $this->result_saveXML();
  }

  public function result_val_main() {
    $this->xml->data = array();
    foreach($this->data as $key => $value) {
      $attr = ($this->data[$key]["error"] !== "")? 0: 1;
      $name = (isset($this->conf[$key]["name"]))? $this->conf[$key]["name"]: $key;
      $this->xml->error       = $this->xml->channel->appendChild($this->xml->dom->createElement('error'));
      $this->xml->error_val   = $this->xml->error->setAttribute("value",$this->data[$key]["value"]);
      $this->xml->error_key   = $this->xml->error->setAttribute("key",$key);
      $this->xml->error_name  = $this->xml->error->setAttribute("name",$name);
      $this->xml->error_flg   = $this->xml->error->setAttribute("flg",$attr);
      $this->xml->error_node  = $this->xml->error->appendChild($this->xml->dom->createTextNode($this->data[$key]["error"]));
    }
  }

  // メンバメソッド(arr)
  public function result_arr_xml() {
    $this->result_head();
    $this->result_res();
    $this->result_arr_main();
    $this->result_saveXML();
  }

  public function result_arr_main() {
    $this->xml->data = array();
    foreach($this->data as $key => $value) {
      $name = (isset($this->conf[$key]["name"]))? $this->conf[$key]["name"]: $key;
      $this->xml->$key       = $this->xml->channel->appendChild($this->xml->dom->createElement($key));
      $this->xml->$key->name = $this->xml->$key->setAttribute("name",$name);
      $this->xml->$key->key  = $this->xml->$key->setAttribute("key",$key);
      for($i = 0; $i < count($this->data[$key]["value"]); $i++){
        $attr = ($this->data[$key]["error"][$i] !== "")? 0: 1;
        $this->xml->error       = $this->xml->$key->appendChild($this->xml->dom->createElement('error'));
        $this->xml->error_val   = $this->xml->error->setAttribute("value",$this->data[$key]["value"][$i]);
        $this->xml->error_index = $this->xml->error->setAttribute("index",$i);
        $this->xml->error_flg   = $this->xml->error->setAttribute("flg",$attr);
        $this->xml->error_node  = $this->xml->error->appendChild($this->xml->dom->createTextNode($this->data[$key]["error"][$i]));
      }
    }
  }

  // メンバメソッド(common)
  public function result_head() {
    $this->xml->dom = new DOMDocument("1.0","UTF-8");
    $this->xml->dom->formatOutput = ture;
    $this->xml->channel = $this->xml->dom->appendChild($this->xml->dom->createElement("channel"));
  }

  public function result_res() {
    $this->xml->result[$key] = array();
    foreach($this->result as $key => $value) {
      $this->xml->result[$key]        = $this->xml->channel->appendChild($this->xml->dom->createElement($key));
      $this->xml->result[$key]->node  = $this->xml->result[$key]->appendChild($this->xml->dom->createTextNode($value));
    }
  }

  public function result_saveXML() {
    header('Content-Type: application/xml');
    header("Cache-control: no-cache");
    echo $this->xml->dom->saveXML();
  }

} //END post_result_xml
