<?php

/*----------------------------------------------------------
基本設定
----------------------------------------------------------*/

// CSSのパス
define("PATH_FILE" , "style.css");

// スクリーンショットパス
define("PATH_THUMB" , "screenshot");

// リファラによる外部使用の制限（する:true/しない:false）
define("CONF_LIMIT_REF" , true);

// SSL（https）の利用（する:true/しない:false）
define("CONF_USE_SSL" , false);

// 共有SSLの利用（する:true/しない:false）
define("CONF_USE_SHEAREDSSL" , false);

// 共有SSLのURL
define("CONF_URL_SHEAREDSSL" , "");

// テンプレート設定
$conf_html = array(
  "login_regist"    => "template/html_login_regist.php",    // ログイン
  "login_forgot"    => "template/html_login_forgot.php",    // パスワード再発行
  "login_reissue"   => "template/html_login_reissue.php",   // パスワード再発行完了
  "install_top"     => "template/html_install_top.php",     // インストール開始
  "install_user"    => "template/html_install_user.php",    // インストール・1.ユーザー作成
  "install_config"  => "template/html_install_config.php",  // インストール・2.基本設定
  "install_confirm" => "template/html_install_confirm.php", // インストール・3.入力内容確認
  "install_finish"  => "template/html_install_finish.php",  // インストール完了
  "prof_edit"       => "template/html_prof_edit.php",       // 基本設定
  "prof_upload"     => "template/html_prof_upload.php",     // プロフィール画像
  "prof_theme"      => "template/html_prof_theme.php",      // テーマ選択
  "folder_upload"   => "template/html_folder_upload.php",   // フォルダアップロード
  "folder_edit"     => "template/html_folder_edit.php",     // フォルダ編集
  "folder_make"     => "template/html_folder_make.php",     // フォルダを作成
  "file_upload"     => "template/html_file_upload.php",     // ファイルアップロード
  "file_edit"       => "template/html_file_edit.php",       // ファイル編集
  "top"             => "template/html_top.php",             // トップ
  "error"           => "template/html_error.php",           // エラー
  "mail_install"    => "template/mail_install.php",         // インストール完了メール送信
  "mail_reissue"    => "template/mail_reissue.php"          // パスワード再発行メール送信
);

// メール送信設定
$conf_mail = array(
  "mailer"   => "",  // メーラーの名前
  "from"     => "ImgPortfolio",  // 送信元名前＆メールアドレス
  "to"       => "",  // 送信先
  "reply_to" => "",  // 返信先
  "bcc"      => ""   // BCCメールアドレス（省略可）
);

// エラー表示設定
$conf_msg = array(
  "must"   => "必須項目です。",
  "num"    => "半角数字で入力してください。",
  "email"  => "メールアドレスが正しくありません。",
  "tel"    => "半角数字で入力してください。",
  "text"   => "テキストを入力してください。",
  "text_h" => "全角ひらがなで入力してください。",
  "text_k" => "全角カタカナで入力してください。",
  "text_s" => "半角英数字で入力してください。",
  "text_p" => "パスを入力してください。",
  "leng"   => "桁の",
  "min"    => "文字以上の",
  "max"    => "文字以下の",
  "chk"    => "入力内容が一致しません。",
  "error"  => "入力内容に不備があります。"
);

$conf_msg_extends = array(
  "failed"        => "が違います。",
  "must"          => "を入力してください。",
  "folder_failed" => "フォルダ名が不正です。",
  "folder_none"   => "フォルダ名が選択されていません。",
  "folder_dupli"  => "同じ名前のフォルダが既に存在します。",
  "pub_failed"    => "公開設定が不正です。",
  "pub_none"      => "公開設定が選択されていません。",
  "archive_type"  => "アップロードできるファイルはzipのみです。",
  "file_type"     => "アップロードできるファイルはgif/jpeg/pngです。",
  "file_kind"     => "ファイル名は半角英数字にしてください。",
  "file_none"     => "ファイルが選択されていません。",
  "file_dupli"    => "同じ名前のファイルが既に存在します。"
);



/*----------------------------------------------------------
項目設定：フォルダ編集
----------------------------------------------------------*/

$user_data = array(
  "user" => array(
      "name" => "ユーザー名",
      "type" => "text",
      "kind" => "text_s",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "pass" => array(
      "name" => "パスワード",
      "type" => "text",
      "kind" => "text_s",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  )
);



/*----------------------------------------------------------
項目設定：基本設定編集
----------------------------------------------------------*/

$prof_data = array(
  "site_name" => array(
      "name" => "サイト名",
      "type" => "text",
      "kind" => "text",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "site_description" => array(
      "name" => "サイト・説明文",
      "type" => "textarea",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "site_keyword" => array(
      "name" => "サイト・キーワード",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "site_copy" => array(
      "name" => "サイト・コピーライト",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "site_robots" => array(
      "name" => "このサイトを検索エンジンに登録しない",
      "type" => "checkbox",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "false",
      "chk"  => ""
  ),
  "mail_name" => array(
      "name" => "Eメール",
      "type" => "text",
      "kind" => "email",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "mail_disp" => array(
      "name" => "プロフィールにEメールを表示する",
      "type" => "checkbox",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => 1,
      "chk"  => ""
  ),
  "prof_disp" => array(
      "name" => "プロフィールを表示する",
      "type" => "checkbox",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => 1,
      "chk"  => ""
  ),
  "prof_name" => array(
      "name" => "プロフィール・名前",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "prof_description" => array(
      "name" => "プロフィール・説明文",
      "type" => "textarea",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "lnk_twttr" => array(
      "name" => "リンク・twitter",
      "type" => "text",
      "kind" => "text_s",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "lnk_facebook" => array(
      "name" => "リンク・facebook",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "lnk_mixi" => array(
      "name" => "リンク・mixi",
      "type" => "text",
      "kind" => "num",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "lnk_blog" => array(
      "name" => "リンク・BLOG",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "allow_tag" => array(
      "name" => "許可するHTMLタグ",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "a font b strong i em u",
      "chk"  => ""
  ),
  "themes_pc" => array(
      "name" => "PC版・テンプレート選択",
      "type" => "radio",
      "kind" => "text_p",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "themes_mobile" => array(
      "name" => "携帯版・テンプレート選択",
      "type" => "radio",
      "kind" => "text_p",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "themes_smartphone" => array(
      "name" => "スマートフォン版・テンプレート選択",
      "type" => "radio",
      "kind" => "text_p",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "pass_change" => array(
      "name" => "パスワード変更",
      "type" => "text",
      "kind" => "text_s",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "pass_check" => array(
      "name" => "パスワード変更（確認）",
      "type" => "text",
      "kind" => "text_s",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => "pass_change"
  )
);



/*----------------------------------------------------------
項目設定：フォルダ編集
----------------------------------------------------------*/

$folder_data = array(
  "folder_dir" => array(
      "name" => "フォルダ名",
      "type" => "text",
      "kind" => "text_s",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "folder_name" => array(
      "name" => "タイトル",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "folder_pub" => array(
      "name" => "公開設定",
      "type" => "checkbox",
      "kind" => "num",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  )
);



/*----------------------------------------------------------
項目設定：ファイル編集
----------------------------------------------------------*/

$file_data = array(
  "folder_dir" => array(
      "name" => "フォルダ名",
      "type" => "text",
      "kind" => "text_s",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "file_name" => array(
      "name" => "ファイル名",
      "type" => "text",
      "kind" => "text",
      "must" => 1,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  ),
  "file_body" => array(
      "name" => "キャプション",
      "type" => "text",
      "kind" => "text",
      "must" => 0,
      "leng" => "",
      "min"  => "",
      "max"  => "",
      "def"  => "",
      "chk"  => ""
  )
);
