<?php

function init($code = 'utf-8') {
  // 文字コード関連
  ini_set("output_buffering", "On");
  ini_set("output_handler", "mb_output_handler");
  ini_set("default_charset", $code);
  mb_language("Japanese");
  mb_internal_encoding ($code);
  mb_http_input("auto");
  mb_http_output($code);
  mb_detect_order("auto");
  mb_substitute_character("none");
  ob_start("mb_output_handler");

  // magic_quotes_gpc = On の場合の対策
  init_strip_magic_quotes();
}

// magic_quotes_gpc = On の場合の対策
// refered to:http://pentan.info/php/magic_quotes_on.html
function init_strip_magic_quotes(){
  if (get_magic_quotes_gpc()) {
    function strip_magic_quotes_slashes($arr){
      return is_array($arr) ?
      array_map('strip_magic_quotes_slashes', $arr) :
      stripslashes($arr);
    }
    $_GET     = strip_magic_quotes_slashes($_GET);
    $_POST    = strip_magic_quotes_slashes($_POST);
    $_REQUEST = strip_magic_quotes_slashes($_REQUEST);
    $_COOKIE  = strip_magic_quotes_slashes($_COOKIE);
  }
}
// lifetime関連
function init_lifetime($value = '21600') {
  ini_set('session.cookie_lifetime',$value); //cookie使用開始後有効時間（秒）
  ini_set('session.gc_maxlifetime',$value);  //最終アクセス後有効時間（秒）
}

// session関連
function init_session($value = 'imgp_login') {
  $path = get_install_path();
  ini_set('session.use_cookies', 1);
  ini_set('session.use_only_cookies', 1);
  ini_set('session.use_trans_sid', 0);
  ini_set('session.cookie_path',$path);
  ini_set('session.name', $value);
  ini_set('session.cache_limiter', 'nocache');
  session_start();
}

// htmlspecialchars
function html_spc($str){
  if(is_array($str)){
    return array_map("h",$str);
  }else{
    $str = stripslashes($str); //バックスラッシュを排除
    $str = htmlspecialchars($str,ENT_QUOTES);
    return $str;
  }
  return false;
}

// 許可したhtmlタグだけエスケープせず出力
function html_escp($str,$tag = array()){
  if (count($tag) == 0 ) return $str;
  foreach($tag as $key => $item) {
    if (strpos($item, '/') === false) {
      $str = preg_replace_callback("/&lt;\/?". $item . "( .*?&gt;|\/?&gt;)/i","html_unescp", $str);
    }
  }
  return $str;
}

// タグを変換する
function html_unescp($str){
  $sStr = $str[0];
  $sStr = str_replace("&lt;", "<", $sStr);
  $sStr = str_replace("&gt;", ">", $sStr);
  $sStr = str_replace("&quot;", "\"", $sStr);
  return $sStr;
}

// 文字列エンコード
function convert_enc($str,$code="utf-8") {
  return mb_convert_encoding($str, $code, "auto");
}

// クォーテーション(')(")の前にバックスラッシュを付加（エスケープ）
function rep_quotes_add($str, $esc = false){
  if($esc) {
    $str = str_replace("'","&apos;",$str);
    $str = str_replace('"','&quot;',$str);
  } else {
    $str = str_replace("'","\'",$str);
    $str = str_replace('"','\"',$str);
  }
  return $str;
}

// スラッシュ(/)の前にバックスラッシュを付加（エスケープ）
function rep_backslash_add($str, $esc = false){
  if($esc) {
    $str = str_replace("/","&frasl;",$str);
  } else {
    $str = str_replace("/","\/",$str);
  }
  return $str;
}

// 0をFALSEではなく数値文字列として評価する
function val_def($value) {
  if(is_array($value)){
    return(count($value));
  } elseif($value != ""){
    return 1;
  } else {
    return 0;
  }
}
// 値が配列の場合は結合する
function val_marge($values,$item="") {
  if(is_array($values)){
    $i = 0;
    $obj = "";
    $item = ($item !== "")? $item: ",";
    foreach($values as $value){
      $str = ($i == 0)? "": $item;
      $obj .= $str.$value;
      $i++;
    }
    return $obj;
  }
  return false;
}

// リファラによる外部使用の制限
function limit_referer(){
  if(CONF_LIMIT_REF){
    if(CONF_USE_SSL == true){
      $protcol = 'https://';
    } else {
      $protcol = 'http://';
    }
    $ref  = preg_replace("/^(https?:\/\/.*?)\/.*$/","$1",$_SERVER['HTTP_REFERER']);
    if(CONF_USE_SHEAREDSSL){
      $host = $protcol.CONF_URL_SHEAREDSSL;
      $pattarn = '/'.rep_backslash_add($host).'/';
    } else {
      $host = $protcol.$_SERVER['HTTP_HOST'];
      $pattarn = '/'.rep_backslash_add($host).'/';
    }
    if(preg_match($pattarn,$_SERVER['HTTP_REFERER'])){
      return false;
    } else {
      return true;
    }
  } else {
    return false;
  }
}
// ログインしていない場合はログイン画面に戻る
function limit_login($login){
  if(!$login){
    header("Location: ../login.php");
    exit;
  } else {
    return false;
  }
}

//fgetcsv文字化け対策
//referred to: http://yossy.iimp.jp/wp/?p=56
function reg_fgetcsv (&$handle, $length = null, $d = ',', $e = '"') {
  $d = preg_quote($d);
  $e = preg_quote($e);
  $_line = "";
  while (($eof != true) and (!feof($handle))) {
  //while ($eof != true) {
    $_line .= (empty($length) ? fgets($handle) : fgets($handle, $length));
    $itemcnt = preg_match_all('/'.$e.'/', $_line, $dummy);
    if ($itemcnt % 2 == 0) $eof = true;
  }
  $_csv_line = preg_replace('/(?:\r\n|[\r\n])?$/', $d, trim($_line));
  $_csv_pattern = '/('.$e.'[^'.$e.']*(?:'.$e.$e.'[^'.$e.']*)*'.$e.'|[^'.$d.']*)'.$d.'/';
  preg_match_all($_csv_pattern, $_csv_line, $_csv_matches);
  $_csv_data = $_csv_matches[1];
  for($_csv_i=0;$_csv_i<count($_csv_data);$_csv_i++){
    $_csv_data[$_csv_i]=preg_replace('/^'.$e.'(.*)'.$e.'$/s','$1',$_csv_data[$_csv_i]);
    $_csv_data[$_csv_i]=str_replace($e.$e, $e, $_csv_data[$_csv_i]);
  }
  return empty($_line) ? false : $_csv_data;
}

// WEBサイトのURI取得
function get_uri(){
  if(CONF_USE_SSL) {
    $protcol = "https://";
  } else {
    $protcol = "http://";
  }
  if(CONF_USE_SHEAREDSSL && CONF_URL_SHEAREDSSL !== "") {
    $host = CONF_URL_SHEAREDSSL;
  } else {
    $host = $_SERVER['SERVER_NAME'];
  }
  $url = $protcol.$host.$_SERVER['REQUEST_URI'];
  $url_rep = preg_replace('/admin\//', '', $url);
  $url_rep = preg_replace('/[-_?=a-zA-Z0-9]*\.php[-_?=a-zA-Z0-9]*$/', '', $url_rep);
  return $url_rep;
}

function get_install_path(){
  $url  = $_SERVER['REQUEST_URI'];
  $url_rep = preg_replace('/admin\//', '', $url);
  $url_rep = preg_replace('/[-_?=a-zA-Z0-9]*\.php[-_?=a-zA-Z0-9]*$/', '', $url_rep);
  return $url_rep;
}

// user.csv読み込み
function get_data_user($filename){
  if(filesize($filename) > 0) {
    $handle = fopen($filename,"r");
    while (($tmp = reg_fgetcsv($handle)) !== false) {
      $data["user"] = $tmp[0];
      $data["pass"] = $tmp[1];
    }
    fclose($handle);
    return $data;
  }
  return false;
}

// config.csv読み込み
function get_data_conf($filename){
  if(filesize($filename) > 0) {
    $handle = fopen($filename,"r");
    while (($tmp = reg_fgetcsv($handle)) !== false) {
      $data[$tmp[0]] = $tmp[1];
    }
    fclose($handle);
    return $data;
  }
  return false;
}

// folderlist.csv読み込み
function get_data_dir($filename){
  if(filesize($filename) > 0) {
    $row = 0;
    $handle = fopen($filename,"r");
    while (($tmp = reg_fgetcsv($handle)) !== false) {
      $data[$row]["dir"]   = convert_enc($tmp[0]);
      $data[$row]["name"] = convert_enc($tmp[1]);
      $data[$row]["pub"]   = (isset($tmp[2]))? convert_enc($tmp[2]): 1;
      $row++;
    }
    fclose($handle);
    return $data;
  }
  return false;
}

// filelist.csv読み込み
function get_data_files($filename){
  if(filesize($filename) > 0) {
    $row = 0;
    $handle = fopen($filename,"r");
    while (($tmp = reg_fgetcsv($handle)) !== false) {
      $data[$row]["dir"]  = convert_enc($tmp[0]);
      $data[$row]["name"] = convert_enc($tmp[1]);
      $data[$row]["body"] = convert_enc($tmp[2]);
      $row++;
    }
    fclose($handle);
    return $data;
  }
  return false;
}

// CSV書き込み
function write_data($filename,$line,$lineNew=""){
  $handle = fopen($filename, "w");
  flock($handle,LOCK_EX);
  if($lineNew !== ""){
    fwrite($handle, $lineNew); // これから書き込む内容を書き込む
  }
  fwrite($handle, $line); // 今まで書き込んだ内容を書き込む
  flock($handle,LOCK_UN);
  fclose($handle); // 書き込みモード終了
}

// 投稿エラーチェック1
function chk_post_error_arr($value){
  $flg = true;
  foreach($value as $key1 => $val1){
    foreach($val1 as $key2 => $val2){
      if($val2 == false){
        $flg = false;
        break 2;
      }
    }
  }
  return $flg;
}

// 投稿エラーチェック2
function chk_post_error_val($value){
  $flg = true;
  foreach($value as $key => $val){
    if($val == false){
      $flg = false;
      break;
    }
  }
  return $flg;
}

// user.csvの読み込みをチェック
function chk_data_user($filename){
  if(filesize($filename) > 0) {
    $handle = fopen($filename,"r");
    while (($tmp = reg_fgetcsv($handle)) !== false) {
      $data["user"] = $tmp[0];
      $data["pass"] = $tmp[1];
    }
    fclose($handle);
    if($data["user"] !== "" && $data["pass"] !== "") {
      return true;
    } else {
      return false;
    }
  }
  return false;
}

// テーマリスト取得
function theme_data ($path_dir,$path_file,$path_thumb){
  $theme_dir = array();
  foreach(scandir($path_dir) as $value) {
    if (is_dir($path_dir.$value) && $value !== "." && $value !== ".." && preg_match("/^[!-~]+$/", $value)){
      array_push($theme_dir, $value);
    }
  }
  $theme_list = array();
  foreach($theme_dir as $value) {
    if (is_file($path_dir.$value."/".$path_file) && preg_match("/^[!-~]+$/", $value)){
      $theme_list[$value] = $path_dir.$value."/".$path_file;
    }
  }
  $theme_data = array();
  foreach($theme_list as $key => $value) {
    // テーマリスト・メタ情報取得
    $stylelines = explode("\n", implode('', file($value)));
    if ($stylelines) {
      $f = fopen($value, 'r');
      foreach($stylelines as $line) {
        if (strpos($line, 'Theme Name:') !== false){
          $str = theme_data_strrep("Theme Name:", $line);
          $theme_data[$key]["name"] = $str;
        }
        if (strpos($line, 'Theme URI:') !== false){
          $str = theme_data_strrep("Theme URI:", $line);
          $theme_data[$key]["uri"] = $str;
        }
        if (strpos($line, 'Description:') !== false){
          $str = theme_data_strrep("Description:", $line);
          $theme_data[$key]["description"] = $str;
        }
        if (strpos($line, 'Version:') !== false){
          $str = theme_data_strrep("Version:", $line);
          $theme_data[$key]["version"] = $str;
        }
        if (strpos($line, 'Author:') !== false){
          $str = theme_data_strrep("Author:", $line);
          $theme_data[$key]["author"] = $str;
        }
        if (strpos($line, 'Author URI:') !== false){
          $str = theme_data_strrep("Author URI:", $line);
          $theme_data[$key]["author_uri"] = $str;
        }
        if (strpos($line, 'Sample URI:') !== false){
          $str = theme_data_strrep("Sample URI:", $line);
          $theme_data[$key]["sample_uri"] = $str;
        }
        $theme_data[$key]["path"] = preg_replace('/\.\.\//', '', $path_dir.$key."/");
      }
      fclose($f);
    }
    // テーマリスト・サムネイル取得
    $extension_arr = array("png","PNG","jpg","JPG","jpeg","JPEG","gif","GIF");
    $extension_flg = false;
    foreach($extension_arr as $extension) {
      if (is_file($path_dir.$key."/".$path_thumb.".".$extension)){
        $theme_data[$key]["thumb"] = $path_dir.$key."/".$path_thumb.".".$extension;
        $extension_flg = true;
        break;
      }
    }
    if(!$extension_flg){
      $theme_data[$key]["thumb"] = "static/images/".$path_thumb.".png";
    }
  }
  return $theme_data;
}

// テーマリストの文字列短縮
function theme_data_strrep ($rep,$line){
  $line = str_replace($rep, "", $line);
  $line = str_replace(" ", "", $line);
  return $line;
}

// ディレクトリ削除
function remove_directory($dir) {
  if ($handle = opendir("$dir")) {
    while (false !== ($item = readdir($handle))) {
     if ($item != "." && $item != "..") {
       if (is_dir("$dir/$item")) {
         remove_directory("$dir/$item");
       } else {
         unlink("$dir/$item");
         //echo " removing $dir/$item<br>\n";
       }
     }
    }
    closedir($handle);
    rmdir($dir);
    return true;
  } else {
    return false;
  }
}

// ランダム文字列生成
function randam_str($num="6"){
  $str = "abcdefghkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ012345679";
  $arr = preg_split("//", $str, 0, PREG_SPLIT_NO_EMPTY);
  $result = "";
  for ($i = 0; $i < $num; $i++) {
    $result .= $arr[array_rand($arr, 1)];
  }
  return $result;
}
