<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

//config.csvの値を取得
$config = get_data_conf("../".PATH_CONF);
$tag = explode(" ", $config["allow_tag"]);

//user.csvの値を取得
$account = get_data_user("../".PATH_USER);

//テーマリスト取得
$config_theme_pc     = theme_data("../".PATH_DIR_PC,PATH_FILE,PATH_THUMB);
$config_theme_mobile = theme_data("../".PATH_DIR_MOBILE,PATH_FILE,PATH_THUMB);
$config_theme_smartphone = theme_data("../".PATH_DIR_SMARTPHONE,PATH_FILE,PATH_THUMB);

//ノード取得
$path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
$path->get_path();
$node = new item_node($path->dir_name,$path->dir_path,$path->csv_dir,$path->csv_files,$config["allow_tag"]);

//ステータス
$status = (isset($_GET["status"]))? html_spc($_GET["status"]): "";

switch($status){
  //ログアウト処理
  case "logout":
    $login = false;
    unset($_SESSION["login"]); //ログインセッションを破棄
    header("Location: ../login.php");
    break;
  //テンプレート読み込み
  case "prof_edit":
    include_once($conf_html['prof_edit']);
    break;
  case "prof_upload":
    include_once($conf_html['prof_upload']);
    break;
  case "prof_theme":
    include_once($conf_html['prof_theme']);
    break;
  case "folder_upload":
    include_once($conf_html['folder_upload']);
    break;
  case "folder_make":
    include_once($conf_html['folder_make']);
    break;
  case "folder_edit":
    include_once($conf_html['folder_edit']);
    break;
  case "file_upload":
    include_once($conf_html['file_upload']);
    break;
  case "file_edit":
    include_once($conf_html['file_edit']);
    break;
  case "error":
    include_once($conf_html['error']);
    break;
  default:
    include_once($conf_html['top']);
}

//var_dump($msg_theme);


?>