<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


// 入力チェック
if (isset($_POST)){

  // リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  //user.csvの値を取得
  $account = get_data_user("../".PATH_USER);

  //config.csvの値を取得
  $config  = get_data_conf("../".PATH_CONF);

  $post = new extend_post_check($_POST,$prof_data,$conf_msg_extends);
  $post->check_regist($config);

  // $_POSTを初期化
  unset($_POST);

  if($post->data["mail_name"]["flg"]){

    //パスワード生成＆書き込み
    $new_user = $account["user"];
    $new_pass = randam_str();
    $new_hash = md5($new_pass);
    $new_line = "";
    $new_line .= "\"".$new_user."\",\"".$new_hash."\"\n";
    write_data("../".PATH_USER,$new_line);

    // メール送信
    $mail_to  = $config["mail_name"];
    $from     = $conf_mail["from"];
    $mailer   = $conf_mail["mailer"];
    $reply_to = $conf_mail["reply_to"];
    $header = "From: $from\n";
    if($mailer !== ""){ $header .= "X-Mailer: $mailer ". phpversion(). "\n"; }
    if($reply_to !== ""){ $header .= "Reply-To: $reply_to\n"; }

    // 送信処理
    $login_uri = get_uri()."login.php";
    include_once($conf_html["mail_reissue"]);
    mb_send_mail($mail_to, $mail_subject, $mail_message, $header);

    // 管理画面へ移動
    header("Location: ../login.php?status=reissue");

  } else {
    // エラーセッションを保存
    $_SESSION["data"] = $post->data;
    // ログイン画面へ戻る
    header("Location: ../login.php?status=forgot");
  }

}


?>