<?php

require_once("../include/common.config.php");
require_once("../include/common.class.php");
require_once("include/admin.config.php");
require_once("include/admin.function.php");
require_once("include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

//ログイン判定
limit_login($login);

$result    = array("filepath" => "","result" => "");
$error     = array("prof_image" => "");
$post_data = array("prof_image" => "");

//config.csvの値を取得
$config = get_data_conf("../".PATH_CONF);

//既存ファイルのパスを取得
$arr = array(".gif",".GIF",".jpeg",".JPEG",".jpg",".JPG",".png",".PNG");
for($i = 0; $i < count($arr); $i++){
  if(is_file("../".PATH_DIR_PROF.PATH_FILE_PROF.$arr[$i])){
    list($w,$h,$t,) = getimagesize("../".PATH_DIR_PROF.PATH_FILE_PROF.$arr[$i]);
    $type = array("",".gif",".jpg",".png");
    $result["filepath"] = "../".PATH_DIR_PROF.PATH_FILE_PROF.$type[$t];
  }
}

//ポスト処理
if (isset($_POST)){

  //リファラによる外部使用の制限
  if(limit_referer()){
    header("Location: ./?status=error");
    return true;
  }

  if (is_uploaded_file($_FILES["prof_image"]["tmp_name"])) {
    //入力チェック
    list($w,$h,$t,) = getimagesize($_FILES['prof_image']['tmp_name']);
    if ($t != null && $t < 4){
      $error["prof_image"] = true;
      $post_data["prof_image"]["error"] = "";
    } else {
      $error["prof_image"] = false;
      $post_data["prof_image"]["error"] = $conf_msg_extends["file_type"];
    }
  } else {
    $error["prof_image"] = false;
    $post_data["prof_image"]["error"] = $conf_msg_extends["file_none"];
  }

  //ファイル置換え
  if($error["prof_image"]){

    //既存ファイル削除
    unlink($result["filepath"]);

    //ファイルアップロード
    if (is_uploaded_file($_FILES["prof_image"]["tmp_name"])){
      $type = array("",".gif",".jpg",".png");
      $result["filepath"] = "../".PATH_DIR_PROF.PATH_FILE_PROF.$type[$t];
      move_uploaded_file($_FILES["prof_image"]["tmp_name"], $result["filepath"]);
    }

    $result["result"] = 1;

  } else {
    $result["result"] = 0;
  }
} else {
  $result["result"] = 0;
}


//XML START
$xml = new post_result_xml($result,$post_data);
$xml->result_val_xml();
//XML END


?>