/*
jQuery Script for img-portfolio ver 1.0
Subject: img-portfolio ver 1.0 common.js
Author : TANAKA Hirohito by CVP(http://cvp-web.net/)
Date   : 2010.04.07
--------------------------------------*/


$().ready(function() {
  this.scrollSet = scrollSet("#container",'#mainSub');
  this.htmlHover = hoverCss(".helpBtn,#editBtn span,#editResult .close span");
  return this;
}); //ready


var scrollSet = function(value1,value2) {
  //スクロール・トップ
  var spd1 = Math.floor($(value1).height() / 1.5);
  $("a[href*=#]").click(function() {
    if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {
      var target = $(this.hash);
      target = target.length && target || $("[name=" + this.hash.slice(1) +"]");
      if (target.length) {
        var targetOffset = target.offset().top;
        $('html,body').animate({ scrollTop: targetOffset }, spd1);
        return false;
      }
    }
  });
  //スクロール・メニュー
  var spd2 = 1000;
	$(value2).scrollFollow({
	  speed: spd2,
	  offset: 20,
	  killSwitch: 'scrollMenuBtn',
	  onText:  'scroll menu OFF',
	  offText: 'scroll menu ON'
	});
}

var helpSet = function(value) {
  if ($.cookie(value)) {
    $("div.help").hide();
    $("p.helpBtn").text("[ヘルプを表示]");
  } else {
    $("div.help").show();
    $("p.helpBtn").text("[ヘルプを隠す]");
  }
}


var helpBtn = function(value) {
  $("p.helpBtn").bind("click",function () {
    if ($.cookie(value)) {
      $("div.help").slideDown(function(){
        $("p.helpBtn").text("[ヘルプを隠す]");
        $.cookie(value, '', { expires: -1 }); //cookieを削除
      });
    } else {
      $("div.help").slideUp(function(){
        $("p.helpBtn").text("[ヘルプを表示]");
        $.cookie(value, 1, { expires: 365 * 10 }); //cookieをセットする
      });
    }
  });
}


var postBtn = function() {
  $("#editResult > .close > span").bind("click",function(){
    $("#editResult").slideUp(function(){
      $("#editResult > .msg").html("");
    });
  });
}


var hoverCss = function(value) {
  $(value).hover(function(){
    $(this).css("cursor","pointer");
  },function(){
    $(this).css("cursor","default");
  });
}

