<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>ファイルを編集 - Img-Portfolio</title>

<link rel="stylesheet" href="static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="static/css/base.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="static/images/common/favicon.ico" />

<script type="text/javascript" src="static/js/jquery1.5.2.min.js"></script>
<script type="text/javascript" src="static/js/ui.core.js"></script>
<script type="text/javascript" src="static/js/cookie.js"></script>
<script type="text/javascript" src="static/js/scrollfollow.js"></script>
<script type="text/javascript" src="static/js/sortable.js"></script>
<script type="text/javascript" src="static/js/lazyLoad.js"></script>
<script type="text/javascript" src="static/js/common.js"></script>
<script type="text/javascript">
//<![CDATA[
jQuery().ready(function() {
  this.helpSet   = helpSet("file_edit");
  this.helpBtn   = helpBtn("file_edit");
  this.lazyLoad  = lazyLoad();
  this.postStyle = postStyle();
  this.postSort  = postSort();
  this.postEdit  = postEdit();
  this.postCheck = postCheck();
  this.editHover = hoverCss("#check #delete p.cancel span,,#check #trans p.cancel span");
  return this;
}); //ready

var lazyLoad = function() {
  $("img.data_thumb").lazyload({ 
    placeholder : "static/images/common/loading-circle_g.gif",
    effect : "fadeIn"
  });
}

var postStyle = function() {
  $(".fileedit_tbl").not(".data_none").find("tbody > tr")
    .hover(function(){
      $(this).css({"cursor":"move"});
      $(this).addClass("selected");
    },function(){
      $(this).css({"cursor":"default"});
      $(this).removeClass("selected");
    });
  $("textarea.file_body")
    .focus(function(){
      $(this).addClass("selected");
    })
    .blur(function(){
      $(this).removeClass("selected");
    });
}

var postSort = function() {
  $(".fileedit_tbl").not(".data_none").sortable({
    items      : "tbody > tr",
    cursor     : "move",
    start      : function(){},
    stop       : function(){
      $('.chk_1').html("");
      $('.chk_2').html("");
      $('input.folder_dir').each(function(i) {
        var folder_dir = $('input.folder_dir').eq(i).val();
        $('.chk_1').append(folder_dir);
      });
      $('input.folder_name').each(function(i) {
        var folder_name = $('input.folder_name').eq(i).val();
        $('.chk_2').append(folder_name);
      });
    },
    sort       : function(){}
  });
}

var postEdit = function() {
  postBtn();
  $("#editBtn > span").bind("click",function(){
    $("#editBtn > img").css({"display":"block"});
    $("#editResult").removeClass().css({"display":"none"});
    $("#editBtn > span").unbind("click");
    $("#editBtn > span").text("保存中");
    $(".data_field > .error_item").remove();
    var file_body   = new Array();
    var file_name   = new Array();
    var folder_dir = new Array();
    $('.file_body').each(function(i) {
      file_body[i]   = $('.file_body').eq(i).val();
    });
    $('.file_name').each(function(i) {
      file_name[i]   = $('.file_name').eq(i).val();
    });
    $('.folder_dir').each(function(i) {
      folder_dir[i] = $('.folder_dir').eq(i).val();
    });
    $.ajax({
      type: "POST",
      url: "file-edit.php",
      data: {
        "file_body[]"   : file_body,
        "file_name[]"   : file_name,
        "folder_dir[]" : folder_dir
      },
      cache: false,
      dataType: "xml",
      timeout: 10000,
      error:function() {
        $("#editResult").addClass("error");
        $("#editResult > .msg").html("通信エラー！設定を変更できません。");
        $("#editResult").slideDown();
        $("#editBtn > img").css({"display":"none"});
        $("#editBtn > span").text("変更を保存");
        postEdit();
        return true;
      },
      success:function(xml) {
        var result = $(xml).find("result").text();
        if(result == 1){
          $("#editResult").addClass("complete");
          $("#editResult > .msg").html("設定を変更しました！<ul><li><a href=\"../\" target=\"_blank\">サイトを表示<\/a><\/li><\/ul>");
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        } else {
          $("#editResult").addClass("error");
          $("#editResult > .msg").html("エラー！設定を変更できません。");
          var obj = "";
          $("file_body",xml).find("error").each(function(i){
            var dir   = $("folder_dir",xml).find("error").eq(i).attr("value");
            var name  = $("file_name",xml).find("error").eq(i).attr("value");
            var key   = $("file_body",xml).attr("key");
            var index = $("file_body",xml).find("error").eq(i).attr("index");
            var value = $("file_body",xml).find("error").eq(i).attr("value");
            var str   = $("file_body",xml).find("error").eq(i).text();
            if(str != ""){
              $(".data_field > #"+ key + (parseInt(index)+1)).before("<div class='error_item'>"+ str +"<\/div>");
              obj += "<li>"+ dir + " - " + name +"は"+ str +"<\/li>";
            }
          });
          if(obj != ""){
            $("#editResult > .msg").append("<ul>"+ obj +"<\/ul>");
          }
          $(".error_item").slideDown();
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        }
        postEdit();
        return true;
      }
    });
  });
}

var postCheck = function() {
  $("input.file_check").bind("click",function(){
    var flg = checkFlg();
    if(flg == false){
      checkBtnOn();
    } else {
      checkBtnOff();
    }
  });
  $("input#file_check_all").bind("click",function(){
    var flg = $(this).attr("checked");
    if(!flg){
      $("input.file_check").attr("checked","");
      checkBtnOn();
    } else {
      $("input.file_check").attr("checked","checked");
      checkBtnOff();
    }
  });
  $("#delete span,#trans span").bind("click",function(){
    $("#delete,#trans").slideUp();
    $("#deleteBtn,#transBtn").removeClass("selected");
  });
}

var checkBtnOn = function() {
  $("#check dt").removeClass("checked");
  $("#check dt.checked span").css("cursor","default");
  $("#delete,#trans").hide();
  $("#deleteBtn,#transBtn").unbind("click");
  $("#deleteBtn,#transBtn").removeClass("selected");
}

var checkBtnOff = function() {
  $("#check dt").addClass("checked");
  $("#check dt.checked span").css("cursor","pointer");
  $("#deleteBtn").bind("click",function(){
    checkSlide("#delete");
  });
  $("#transBtn").bind("click",function(){
    checkSlide("#trans");
  });
}

var checkFlg = function() {
  var flg = false;
  $("input.file_check").each(function(){
    if($(this).attr("checked") == true){
      flg = true;
    }
  });
  return flg;
}

var checkSlide = function(str) {
  if(!$(str+"Btn").hasClass("selected")){
    $("#delete,#trans").hide();
    $("#deleteBtn,#transBtn").removeClass("selected");
    $(str+"Btn").addClass("selected");
    $(str).slideDown();
  }
}
//]]>
</script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea" class="clearfix">
  <h1 id="top"><a href="./"><img src="static/images/common/logo-img-portfolio.png" alt="Img-Portfolio" width="200" height="60" /></a></h1>
  <ul><li><a href="../" target="_blank">サイトを表示</a></li><li><a href="./?status=logout">ログアウト</a></li></ul>
</div><!-- /#headerArea -->
<hr class="hidden" />

<div id="mainArea" class="body-2-column">

<?php include_once("html_sidemenu.php"); ?>

<div id="mainBody">

<div id="content" class="posts">

<h2><img src="./static/images/icon/file_edit.gif" alt="" width="60" height="40" />ファイルを編集</h2>
<p class="helpBtn">[ヘルプを表示]</p>
<br class="clear" />

<div class="help">
  <p>ファイルのキャプション編集・フォルダ移動・削除・並び替えを行います。</p>
  <ul>
    <li>「フォルダを選択」よりファイルを編集するフォルダを選択します。</li>
    <li>ファイルのキャプションには基本設定「許可するHTMLタグ」で指定したタグを使用できます。</li>
    <li>ファイルの並び替えをする場合は「ファイル・リスト」のセルをドラッグ＆ドロップしてください。</li>
  </ul>
</div>

<?php
$num  = 1;
$col  = 5;
$type = array("","GIF","JPEG","PNG");
$select_num = html_spc($_GET["dir"]);
$select     = (is_numeric($select_num) && $select_num < count($node->dir))? floor($select_num): 0;
?>
<h3>フォルダを選択</h3>
<div class="file_list">
<?php if(count($node->dir) > 0){ ?>
<table border="0" cellpadding="0" cellspacing="0" class="filelist_tbl wordBreak">
  <tbody>
<?php
foreach($node->dir as $i => $dir){
if(($i+1) % $col == 1 || $i == 0){ ?>
    <tr>
<?php } ?>
      <td<?php if($i == $select){echo " class=\"selected\""; } ?>><a href="./?status=file_edit&amp;dir=<?php echo $i; ?>"><?php echo $dir["name"]; ?></a></td>
<?php if(($i+1) % $col == 0){ ?>
    </tr>
<?php }} //END foreach ?>

<?php if(count($node->dir) % $col != 0){ ?>
<?php
$c = count($node->dir);
$m = $col - ($c % $col);
for($j = 0; $j < $m; $j++){ 
?>
      <td>&nbsp;</td>
<?php } //END for ?>
    </tr>
<?php } //END if ?>
  </tbody>
</table>
<?php } else { ?>
<p>フォルダがありません。<br />フォルダをアップロード、または作成してください。</p>
<?php } ?>
</div>

<form action="file-del.php" method="post">

<?php if(count($node->dir) > 0){ ?>
<?php if($node->dir[$select]["total"] > 0){ ?>
<?php foreach($node->dir as $i => $dir){ ?>
<?php if($dir["dir"] == $node->dir[$select]["dir"]){ ?>
<?php $pub = ($dir["pub"])? "": "（非公開）"; ?>
<h3>ファイル・リスト&nbsp;：&nbsp;<?php echo $dir["name"]; ?>&nbsp;<?php echo $pub; ?></h3>

<table border="0" cellpadding="0" cellspacing="0" class="fileedit_tbl wordBreak">
  <thead>
    <tr>
      <th class="data_image">画像</th>
      <th class="data_name">ファイル名 / 情報</th>
      <th class="data_body">キャプション</th>
      <th class="data_del"><input type="checkbox" name="file_check_all" id="file_check_all" /></th>
    </tr>
  </thead>
  <tbody>
<?php foreach($dir["file"] as $j => $file){ ?>
    <tr id="data_row<?php echo $num; ?>">
      <td class="data_image">
        <p><a href="<?php echo $file["path"]; ?>" target="_blank"><img src="../include/img-portfolio.thumb.php?dir=<?php echo $dir["dir"]; ?>&amp;file=<?php echo $j; ?>&amp;size=60&amp;node=all&amp;<?php echo mktime(); ?>" alt="<?php echo $dir["dir"]."-".$j; ?>" class="data_thumb" /></a></p>
      </td>
      <td class="data_name">
        <p><?php echo $file["name"]; ?></p>
        <ul>
          <!--<li><?php echo $file["ext"]; ?></li>-->
          <li>W <?php echo $file["width"]; ?>px × H <?php echo $file["height"]; ?>px</li>
          <li><?php echo $file["date"]; ?></li>
        </ul>
      </td>
      <td class="data_body">
        <p class="data_field">
        <textarea tabindex="<?php echo $num; ?>" name="file_body[]" id="file_body<?php echo $num; ?>" class="file_body" cols="30" rows="2"><?php echo $file["body"]; ?></textarea>
        <input type="hidden" name="file_name[]" id="file_name<?php echo $num; ?>" value="<?php echo $file["name"]; ?>" class="file_name" />
        <input type="hidden" name="folder_dir[]" id="folder_dir<?php echo $num; ?>" value="<?php echo $dir["dir"]; ?>" class="folder_dir" />
        </p>
      </td>
      <td class="data_del">
        <p><input type="checkbox" name="file_check[]" id="file_check<?php echo $num; ?>" class="file_check" value="<?php echo $num - 1; ?>" /></p>
      </td>
    </tr>
<?php $num++; ?>
<?php } //END foreach($dir["file"] as $j => $file) ?>
  </tbody>
</table>
<?php } else { ?>
<?php if(count($dir["file"]) > 0){ ?>
<?php foreach($dir["file"] as $j => $file){ ?>
<input type="hidden" name="file_body[]" id="file_body<?php echo $num; ?>" value="<?php echo str_replace("<br />","",$file["body"]); ?>" class="file_body" />
<input type="hidden" name="file_name[]" id="file_name<?php echo $num; ?>" value="<?php echo $file["name"]; ?>" class="file_name" />
<input type="hidden" name="folder_dir[]" id="folder_dir<?php echo $num; ?>" value="<?php echo $dir["dir"]; ?>" class="folder_dir" />
<?php $num++; ?>
<?php } //END foreach($dir["file"] as $j => $file) ?>
<?php } //END if(count($dir["file"]) > 0) ?>
<?php } //END if($dir["dir"] == $node->dir[$select]["dir"]) ?>
<?php } //END foreach($node->dir as $i => $dir) ?>
<?php } else { ?>
<table border="0" cellpadding="0" cellspacing="0" class="fileedit_tbl wordBreak">
  <thead>
    <tr>
      <th class="data_image">画像</th>
      <th class="data_name">ファイル名 / 情報</th>
      <th class="data_body">キャプション</th>
      <th class="data_del">&nbsp;</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="data_none" colspan="4"><p>ファイルがありません</p></td>
    </tr>
  </tbody>
</table>
<?php foreach($node->dir as $i => $dir){ ?>
<?php if(count($dir["file"]) > 0){ ?>
<?php foreach($dir["file"] as $j => $file){ ?>
<input type="hidden" name="file_body[]" id="file_body<?php echo $num; ?>" value="<?php echo str_replace("<br />","",$file["body"]); ?>" class="file_body" />
<input type="hidden" name="file_name[]" id="file_name<?php echo $num; ?>" value="<?php echo $file["name"]; ?>" class="file_name" />
<input type="hidden" name="folder_dir[]" id="folder_dir<?php echo $num; ?>" value="<?php echo $dir["dir"]; ?>" class="folder_dir" />
<?php $num++; ?>
<?php } //END foreach($dir["file"] as $j => $file) ?>
<?php } //END if(count($dir["file"]) > 0) ?>
<?php } //END foreach($node->dir as $i => $dir) ?>
<?php } //END if($node->dir[$select]["total"] > 0) ?>
<?php } else { ?>
<table border="0" cellpadding="0" cellspacing="0" class="fileedit_tbl data_none wordBreak">
  <thead>
    <tr>
      <th class="data_image">画像</th>
      <th class="data_name">ファイル名</th>
      <th class="data_body">キャプション / 情報</th>
      <th class="data_del">&nbsp;</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="data_none" colspan="4"><p>フォルダがありません。</p></td>
    </tr>
  </tbody>
</table>
<?php } //END if(count($node->dir) > 0) ?>




<input type="hidden" name="folder_select" id="folder_select" value="<?php echo $select; ?>" class="folder_select" />

<?php if(count($node->dir) > 0 && $node->dir[$select]["total"] > 0){ ?>
<dl id="check">
  <dt>チェックしたファイルを&nbsp;&nbsp;：&nbsp;&nbsp;<span id="deleteBtn">削除する</span>&nbsp;&nbsp;|&nbsp;&nbsp;<span id="transBtn">別のフォルダに移動する</span></dt>
  <dd id="delete" class="clearfix">
    <p class="left">本当に削除してよろしいですか？&nbsp;&nbsp;<input type="submit" name="del" value="削除する" /></p>
    <p class="cancel right"><span>キャンセル</span></p>
  </dd>
  <dd id="trans" class="clearfix">
    <p class="left">移動先を指定してください　
    <select name="folder_trans">
<?php foreach($node->dir as $i => $dir){ ?>
    <option<?php if($i == $select){echo " selected=\"selected\""; } ?> value="<?php echo $dir["dir"]; ?>"><?php echo $dir["name"]; ?></option>
<?php } //END for ?>
    </select>
    &nbsp;&nbsp;<input type="submit" name="trans" value="移動する" /></p>
    <p class="cancel right"><span>キャンセル</span></p>
  </dd>
</dl>

<br />

<div id="edit">
  <p id="editBtn" class="clearfix"><span>変更を保存</span><img src="./static/images/common/loading-circle_w_mini.gif" alt="" width="32" height="32" /></p>
  <div id="editResult">
    <p class="msg"></p>
    <p class="close"><span>閉じる</span></p>
    <br class="clear" />
  </div>
</div>
<?php } // END if(count($node->dir) > 0 && $node->dir[$select]["total"] > 0) ?>

</form>
</div><!-- /#content -->

<p class="pagetop"><a href="#top">↑PAGE TOP</a></p>

<br class="clear" />
</div><!-- /#mainBody -->

<br class="clear" />
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->



<?php include_once("html_footer.php"); ?>



</body>
</html>