<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>ファイルをアップロード - Img-Portfolio</title>

<link rel="stylesheet" href="static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="static/css/base.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="static/images/common/favicon.ico" />

<script type="text/javascript" src="static/js/jquery1.5.2.min.js"></script>
<script type="text/javascript" src="static/js/ui.core.js"></script>
<script type="text/javascript" src="static/js/cookie.js"></script>
<script type="text/javascript" src="static/js/scrollfollow.js"></script>
<script type="text/javascript" src="static/js/upload.js"></script>
<script type="text/javascript" src="static/js/common.js"></script>
<script type="text/javascript">
//<![CDATA[


jQuery().ready(function() {
  this.helpSet   = helpSet("file_upload");
  this.helpBtn   = helpBtn("file_upload");
  this.post      = postEdit();
  return this;
}); //ready

var postImage = function(image_url,flg) {
  var now = (new Date()).getTime();
  var image_data = new Image();
  image_data.src = (flg)? image_url +"&"+ now: image_url;
  $(".data_image > img").attr("src",image_data.src);
}

var loadingImage = function() {
  var image_icon = new Image();
  image_icon.src = "static/images/common/loading-circle-150_g.gif";
  $(".data_image > img").attr("src",image_icon.src);
}

var postEdit = function() {
  postBtn();
  $('#editBtn > span').click(function() {
    postUpload(1);
  });
}

var postOverWrite = function() {
  hoverCss('#overwriteBtn > span');
  $('#overwriteBtn > span').click(function() {
    postUpload(0);
  });
}

var postUpload = function(flg) {
  $("#editBtn > img").css({"display":"block"});
  var image_url = "./static/images/common/none-image.gif";
  var dir  = $('#folder_dir').children(':selected').val();
  var body = $('#file_body').val();
  body =  body.replace('"', '&quot;', 'g');
  body =  body.replace("'", "&quot;", 'g');
  $("#editResult").removeClass().css({"display":"none"});
  $("#editBtn > span").unbind("click");
  $("#editBtn > span").text("アップロード中");
  loadingImage();
  $(".data_field > .error_item").remove();
  $('#file_image').upload('file-upload.php',
  {
    "file_flg"   : flg,
    "file_body"  : body,
    "folder_dir" : dir
  },
  function(xml) {
    var result = $(xml).find("result").text();
    var image_new  = $(xml).find("filepath").text();
    var image_type = $(xml).find("type").text();
    var image_dir  = $(xml).find("dir").text();
    var image_file = $(xml).find("file").text();
    var image_flg  = $(xml).find("flg").text();
    if(result == 1 || image_flg == 1){
      postImage("../include/img-portfolio.thumb.php?dir="+image_dir+"&file="+image_file+"&size=150&wtrim=0&htrim=0&node=all",true);
    } else {
      postImage(image_url,false);
    }
    if(result == 1){
      $("#editResult").addClass("complete");
      $("#editResult > .msg").html("ファイルをアップロードしました！<ul><li><a href=\"../\" target=\"_blank\">サイトを表示<\/a><\/li><\/ul>");
      $("#editResult").slideDown("normal",function(){
        postEdit();
      });
      $("#editBtn > img").css({"display":"none"});
      $("#editBtn > span").text("アップロード");
      $("#file_image").attr("value","");
    } else {
      if(image_flg == 1) {
        $("#editResult").addClass("error");
        var obj = "";
        $(xml).find("error").each(function(i){
          var key  = $(xml).find("error").eq(i).attr("key");
          var str  = $(xml).find("error").eq(i).text();
          if(str != ""){
            obj += "<p>"+ str +"<\/p>";
          }
        });
        $("#editResult > .msg").html(obj)
        $("#editResult > .msg").append("<ul><li id=\"overwriteBtn\">上書きしますか？&nbsp;&nbsp;<span>上書きする<\/span><\/li><\/ul>");
        postOverWrite();
      } else {
        $("#editResult").addClass("error");
        $("#editResult > .msg").html("エラー！アップロードできません。");
        var obj = "";
        $(xml).find("error").each(function(i){
          var key  = $(xml).find("error").eq(i).attr("key");
          var str  = $(xml).find("error").eq(i).text();
          if(str != ""){
            $("#"+key).before("<div class='error_item'>"+ str +"<\/div>");
            obj += "<li>"+ str +"<\/li>";
          }
        });
        if(obj != ""){
          $("#editResult > .msg").append("<ul>"+ obj +"<\/ul>");
        }
      }
      $(".error_item").slideDown();
      $("#editResult").slideDown("normal",function(){
        postEdit();
      });
      $("#editBtn > img").css({"display":"none"});
      $("#editBtn > span").text("アップロード");
    }
    return true;
  },
  'xml');
}

//]]>
</script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea" class="clearfix">
  <h1 id="top"><a href="./"><img src="static/images/common/logo-img-portfolio.png" alt="Img-Portfolio" width="200" height="60" /></a></h1>
  <ul><li><a href="../index.php" target="_blank">サイトを表示</a></li><li><a href="./?status=logout">ログアウト</a></li></ul>
</div><!-- /#headerArea -->
<hr class="hidden" />

<div id="mainArea" class="body-2-column">

<?php include_once("html_sidemenu.php"); ?>

<div id="mainBody">

<div id="content" class="posts">

<h2><img src="./static/images/icon/file_upload.gif" alt="" width="60" height="40" />ファイルをアップロード</h2>
<p class="helpBtn">[ヘルプを表示]</p>
<br class="clear" />

<div class="help">
  <p>ギャラリー用の画像ファイルをアップロードします。</p>
  <ul>
    <li>ファイル名は半角英数字にしてください。</li>
    <li>アップロードできるファイル形式はgif/jpeg/pngです。</li>
    <li>ファイルのキャプションには基本設定「許可するHTMLタグ」で指定したタグを使用できます。</li>
  </ul>
</div>

<form action="file-upload.php" method="post" enctype="multipart/form-data">

<table border="0" cellpadding="0" cellspacing="0" class="fileup_tbl">
  <tbody>
    <tr>
      <th class="data_image"><img src="static/images/common/none-image.gif" alt="no-image" /></th>
      <td>
<?php if(count($node->dir) > 0){ ?>
        <fieldset>
          <legend>アップロード先のフォルダを指定</legend>
          <p class="data_field">
            <select tabindex="1" name="folder_dir" id="folder_dir" class="folder_dir">
<?php $num = 1; ?>
<?php foreach($node->dir as $i => $dir){ ?>
              <option value="<?php echo $dir["dir"]; ?>"><?php echo $dir["name"]; ?></option>
<?php $num++; ?>
<?php } //END for dir ?>
            </select>
          </p>
        </fieldset>
        <fieldset>
          <legend>アップロードするファイルを指定</legend>
          <p class="data_field">
            <input type="file" tabindex="2" name="file_image" id="file_image" size="40" />
          </p>
          <p class="cap">アップロードできるファイルの上限は<span><?php echo ini_get('upload_max_filesize'); ?></span>です</p>
        </fieldset>
        <fieldset>
          <legend>キャプション</legend>
          <p class="data_field">
            <textarea tabindex="3" name="file_body" id="file_body" class="file_body" cols="30" rows="2"></textarea>
          </p>
        </fieldset>
<?php } else { ?>
        <p align="center">フォルダがありません。<br />フォルダをアップロード、または作成してください。</p>
<?php } ?>
      </td>
    </tr>
  </tbody>
</table>

<?php if(count($node->dir) > 0){ ?>
<div id="edit">
  <p id="editBtn" class="clearfix"><span>アップロード</span><img src="./static/images/common/loading-circle_w_mini.gif" alt="" width="32" height="32" /></p>
  <div id="editResult">
    <p class="msg"></p>
    <p class="close"><span>閉じる</span></p>
    <br class="clear" />
  </div>
</div>
<?php } ?>

</form>

</div><!-- /#content -->

<p class="pagetop"><a href="#top">↑PAGE TOP</a></p>

<hr class="clear" />
</div><!-- /#mainBody -->

<hr class="clear" />
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->



<?php include_once("html_footer.php"); ?>



</body>
</html>