<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>フォルダを編集 - Img-Portfolio</title>

<link rel="stylesheet" href="static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="static/css/base.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="static/images/common/favicon.ico" />

<script type="text/javascript" src="static/js/jquery1.5.2.min.js"></script>
<script type="text/javascript" src="static/js/ui.core.js"></script>
<script type="text/javascript" src="static/js/cookie.js"></script>
<script type="text/javascript" src="static/js/scrollfollow.js"></script>
<script type="text/javascript" src="static/js/sortable.js"></script>
<script type="text/javascript" src="static/js/lazyLoad.js"></script>
<script type="text/javascript" src="static/js/common.js"></script>
<script type="text/javascript">
//<![CDATA[
jQuery().ready(function() {
  this.helpSet   = helpSet("folder_edit");
  this.helpBtn   = helpBtn("folder_edit");
  this.lazyLoad  = lazyLoad();
  this.postStyle = postStyle();
  this.postSort  = postSort();
  this.postEdit  = postEdit();
  this.postDel   = postDel();
  this.postPub   = postPub();
  this.editHover = hoverCss(".del_on, .del_run, .del_cancel, .pub_on, .pub_run, .pub_cancel");
  return this;
}); //ready

var loader = new Array();
loader["g"] = new Image();
loader["g"].src = "./static/images/common/loading-circle_g_mini.gif";
loader["y"] = new Image();
loader["y"].src = "./static/images/common/loading-circle_y_mini.gif";

var lazyLoad = function() {
  $("img.data_thumb").lazyload({ 
    placeholder : loader["g"].src,
    effect : "fadeIn"
  });
}

var eventMOver = function() {
  $(this).mouseover(function(){
    $(this).css({"cursor":"move"});
    $(this).addClass("selected");
  });
}

var eventMOut = function() {
  $(this).mouseout(function(){
    $(this).css({"cursor":"default"});
    $(this).removeClass("selected");
  });
}

var postStyle = function() {
  $(".folderedit_tbl").not(".data_none").find("tbody > tr").each(function(i){
    $(this).bind("mouseover",eventMOver);
    $(this).bind("mouseout", eventMOut);
  });
  $("input.folder_name")
    .focus(function(){
      $(this).addClass("selected");
    })
    .blur(function(){
      $(this).removeClass("selected");
    });
}

var postSort = function() {
  $(".folderedit_tbl").not(".data_none").sortable({
    items      : "tbody > tr",
    cursor     : "move",
    hoverClass : "hvrclass", 
    start      : function(){},
    stop       : function(){
      $('input.folder_dir').each(function(i) {
        var folder_dir = $('input.folder_dir').eq(i).val();
      });
      $('input.folder_name').each(function(i) {
        var folder_name = $('input.folder_name').eq(i).val();
      });
      $('input.folder_pub').each(function(i) {
        var folder_pub  = $('input.folder_pub').eq(i).val();
      });
    },
    sort : function(){}
  });
}

var postEdit = function() {
  postBtn();
  $("#editBtn > span").bind("click",function(){
    $("#editBtn > img").css({"display":"block"});
    $("#editResult").removeClass().css({"display":"none"});
    $("#editBtn > span").unbind("click");
    $("#editBtn > span").text("保存中");
    $(".data_field > .error_item").remove();
    var folder_dir = new Array();
    var folder_name = new Array();
    var folder_pub  = new Array();
    $('input.folder_dir').each(function(i) {
      folder_dir[i] = $('input.folder_dir').eq(i).val();
    });
    $('input.folder_name').each(function(i) {
      folder_name[i] = $('input.folder_name').eq(i).val();
    });
    $('input.folder_pub').each(function(i) {
      folder_pub[i]  = $('input.folder_pub').eq(i).val();
    });
    $.ajax({
      type: "POST",
      url: "folder-edit.php",
      data: {
        "folder_dir[]" : folder_dir,
        "folder_name[]" : folder_name,
        "folder_pub[]"  : folder_pub
      },
      cache: false,
      dataType: "xml",
      timeout: 10000,
      error:function() {
        $("#editResult").addClass("error");
        $("#editResult > .msg").html("通信エラー！設定を変更できません。");
        $("#editResult").slideDown();
        $("#editBtn > img").css({"display":"none"});
        $("#editBtn > span").text("変更を保存");
        postEdit();
        return true;
      },
      success:function(xml) {
        var result = $(xml).find("result").text();
        if(result == 1){
          $("#editResult").addClass("complete");
          $("#editResult > .msg").html("設定を変更しました！<ul><li><a href=\"../\" target=\"_blank\">サイトを表示<\/a><\/li><\/ul>");
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        } else {
          $("#editResult").addClass("error");
          $("#editResult > .msg").html("エラー！設定を変更できません。");
          var obj = "";
          var name  = $("folder_name",xml).attr("name");
          $("folder_name",xml).find("error").each(function(i){
            var index = $("folder_name",xml).find("error").eq(i).attr("index");
            var value = $("folder_name",xml).find("error").eq(i).attr("value");
            var str   = $("folder_name",xml).find("error").eq(i).text();
            if(str != ""){
              $("#folder_name" + (parseInt(index)+1)).before("<div class='error_item'>"+ str +"<\/div>");
              obj += "<li>"+ value +"は"+ str +"<\/li>";
            }
          });
          if(obj != ""){
            $("#editResult > .msg").append("<ul>"+ obj +"<\/ul>");
          }
          $(".error_item").slideDown();
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        }
        postEdit();
        return true;
      }
    });
  });
}

var postDel = function() {
  $(".controll").find(".del_on").bind("click",function(){
    var str = $(this).attr("id");
    var num = str.replace(/del([0-9]+)$/,"$1");
    $("#data_row"+ num +" > td > .del_field").slideDown();
    $("#data_row"+ num).unbind("mouseover").unbind("mouseout");
    $("#data_row"+ num).removeClass("selected");
    $("#data_row"+ num).addClass("dataedit");
  });
  $(".del_field").find(".del_cancel").bind("click",function(){
    var str = $(this).attr("id");
    var num = str.replace(/del_cancel([0-9]+)$/,"$1");
    $("#data_row"+ num +" > td > .del_field").slideUp();
    $("#data_row"+ num).bind("mouseover",eventMOver).bind("mouseout",eventMOut);
    $("#data_row"+ num).removeClass("dataedit");
  });
  $(".del_field").find(".del_run").bind("click",function(){
    $(".del_run").unbind("click");
    var str = $(this).attr("id");
    var num = str.replace(/del_run([0-9]+)$/,"$1");
    var folder_dir = $("#folder_dir"+num).val();
    $("#data_row"+ num).find(".del_res").html('<img src="'+loader["y"].src+'" />');
    $.ajax({
      type: "POST",
      url: "folder-del.php",
      data: {
        "folder_dir" : folder_dir
      },
      cache: false,
      dataType: "xml",
      timeout: 10000,
      error:function() {
        postDel();
        return true;
      },
      success:function(xml) {
        var result = $(xml).find("result").text();
        if(result == 1){
          postDelResult(num,true);
        } else {
          postDelResult(num,false);
        }
        postDel();
        return true;
      }
    });
  });
}

var postDelResult = function(num,res){
  var str = (res)? "設定完了!!": "エラー!!";
  $("#data_row"+ num).find(".del_res").html(str);
  if(res) {
    var timer = setTimeout(function() {
      $("#data_row"+num +" > td").fadeOut("normal",function(){
        $("#data_row"+num).remove();
        postDel();
      });
    },500);
  } else {
    var timer = setTimeout(function() {
      $("#data_row"+ num +" > td > .del_field").slideUp("normal",function(){
        $("#data_row"+ num).find(".del_res").html("&nbsp;");
        $("#data_row"+ num).removeClass("dataedit");
        postDel();
      });
    },500);
  }
}

var postPub = function() {
  $(".controll").find(".pub_on").bind("click",function(){
    var str = $(this).attr("id");
    var num = str.replace(/pub([0-9]+)$/,"$1");
    $("#data_row"+ num +" > td > .pub_field").slideDown();
    $("#data_row"+ num).unbind("mouseover").unbind("mouseout");
    $("#data_row"+ num).removeClass("selected");
    $("#data_row"+ num).addClass("dataedit");
  });
  $(".pub_field").find(".pub_cancel").bind("click",function(){
    var str = $(this).attr("id");
    var num = str.replace(/pub_cancel([0-9]+)$/,"$1");
    $("#data_row"+ num +" > td > .pub_field").slideUp();
    $("#data_row"+ num).bind("mouseover",eventMOver).bind("mouseout",eventMOut);
    $("#data_row"+ num).removeClass("dataedit");
  });
  $(".pub_field").find(".pub_run").bind("click",function(){
    $(".pub_run").unbind("click");
    var str = $(this).attr("id");
    var num = str.replace(/pub_run([0-9]+)$/,"$1");
    var folder_dir = $("#folder_dir"+num).val();
    var folder_pub  = $("#folder_pub"+num).val();
    $("#data_row"+ num).find(".pub_res").html('<img src="'+loader["y"].src+'" />');
    $.ajax({
      type: "POST",
      url: "folder-pub.php",
      data: {
        "folder_dir" : folder_dir,
        "folder_pub"  : folder_pub
      },
      cache: false,
      dataType: "xml",
      timeout: 10000,
      error:function() {
        postPub();
          $(".chk").html("error");
        return true;
      },
      success:function(xml) {
        var result = $(xml).find("result").text();
        var pub_num  = (folder_pub == 0)? 1: 0;
        if(result == 1){
          postPubResult(num,true,pub_num);
          return true;
        } else {
          postPubResult(num,false,pub_num);
          return true;
        }
      }
    });
  });
}

var postPubResult = function(num,res,pub_num){
  var str = (res)? "設定完了!!": "エラー!!";
  $("#data_row"+ num).find(".pub_res").html(str);
  if(res) {
    var data_str = (pub_num == 0)? "非公開": "公開";
    var run_str  = (pub_num == 0)? "公開に変更": "非公開に変更";
    $("#folder_pub"+ num).val(pub_num);
    $("#data_row"+ num +" > td.data_del > p").html(data_str);
    var timer = setTimeout(function() {
      $("#data_row"+ num +" > td > .pub_field").slideUp("normal",function(){
        $("#data_row"+ num).find(".pub_run").html(run_str);
        $("#data_row"+ num).find(".pub_res").html("&nbsp;");
        $("#data_row"+ num).bind("mouseover",eventMOver).bind("mouseout",eventMOut);
        $("#data_row"+ num).removeClass("dataedit");
        postPub();
      });
    },500);
  } else {
    var timer = setTimeout(function() {
      $("#data_row"+ num +" > td > .pub_field").slideUp("normal",function(){
        $("#data_row"+ num).find(".pub_res").html("&nbsp;");
        $("#data_row"+ num).bind("mouseover",eventMOver).bind("mouseout",eventMOut);
        $("#data_row"+ num).removeClass("dataedit");
        postPub();
      });
    },500);
  }
}
//]]>
</script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea" class="clearfix">
  <h1 id="top"><a href="./"><img src="static/images/common/logo-img-portfolio.png" alt="Img-Portfolio" width="200" height="60" /></a></h1>
  <ul><li><a href="../" target="_blank">サイトを表示</a></li><li><a href="./?status=logout">ログアウト</a></li></ul>
</div><!-- /#headerArea -->
<hr class="hidden" />

<div id="mainArea" class="body-2-column">

<?php include_once("html_sidemenu.php"); ?>

<div id="mainBody">

<div id="content" class="posts">

<div class="chk1"></div>

<h2><img src="./static/images/icon/folder_edit.gif" alt="" width="60" height="40" />フォルダを編集</h2>
<p class="helpBtn">[ヘルプを表示]</p>
<br class="clear" />

<div class="help">
  <p>フォルダのタイトル編集・削除・公開設定・並び替えを行います。</p>
  <ul>
    <li>フォルダの削除はファイル数が０の場合に限ります。</li>
    <li>公開設定が「非公開」となっているフォルダはWEBサイト上に表示されません。</li>
    <li>フォルダの並び替えをする場合は「フォルダ・リスト」のセルをドラッグ＆ドロップしてください。</li>
  </ul>
</div>

<form action="folder-edit.php" method="post">

<h3>フォルダ・リスト</h3>

<?php if(count($node->dir) > 0){ ?>
<table border="0" cellpadding="0" cellspacing="0" class="folderedit_tbl">
  <thead>
    <tr>
      <th class="data_dir">フォルダ名</th>
      <th class="data_count">サムネイル / 情報</th>
      <th class="data_name">タイトル</th>
      <th class="data_del">状態</th>
    </tr>
  </thead>
  <tbody>
<?php 
$num = 1;
foreach($node->dir as $key => $dir){
?>
    <tr id="data_row<?php echo $num; ?>">
      <td class="data_dir">
        <p><?php echo $dir["dir"]; ?></p>
      </td>
      <td class="data_count">
<?php if(count($dir["file"]) > 0){ ?>
        <ul class="clearfix">
<?php 
$thum_n = (count($dir["file"]) <= 3)? count($dir["file"]): 3;
for($i = 0; $i < $thum_n; $i++){ 
?>
          <li><a href="<?php echo $dir["file"][$i]["path"]; ?>" target="_blank"><img src="../include/img-portfolio.thumb.php?dir=<?php echo $dir["dir"]; ?>&amp;file=<?php echo $i; ?>&amp;size=32&amp;wtrim=1&amp;htrim=1&amp;node=all" alt="" class="data_thumb" /></a></li>
<?php } ?>
        </ul>
<?php } else { ?>
        <p style="height:42px;">&nbsp;</p>
<?php } ?>
        <p>ファイル数：<?php echo $dir["total"]; ?></p>
      </td>
      <td class="data_name">
        <p class="data_field">
        <input type="text" tabindex="<?php echo $num; ?>" name="folder_name[]" id="folder_name<?php echo $num; ?>" value="<?php echo $dir["name"]; ?>" class="folder_name" size="30" maxlength="80" />
        <input type="hidden" name="folder_dir[]" id="folder_dir<?php echo $num; ?>" value="<?php echo $dir["dir"]; ?>" class="folder_dir" />
        <input type="hidden" name="folder_pub[]" id="folder_pub<?php echo $num; ?>" value="<?php echo $dir["pub"]; ?>" class="folder_pub" />
        </p>
<?php
$dl    = ($dir["total"] != 0)? "<a href=\"folder-download.php?dir=".$key."\">ダウンロード</a>": "ダウンロード";
$del   = ($dir["total"] == 0)? " class=\"del_on\"": "";
$c_pub = ($dir["pub"] == 0)? "非公開": "公開";
$e_pub = ($dir["pub"] == 0)? "公開に変更": "非公開に変更";
?>
        <ul class="controll">
          <li><span id="del<?php echo $num; ?>"<?php echo $del; ?>>削除</span> | </li>
          <li><?php echo $dl; ?> | </li>
          <li><span id="pub<?php echo $num; ?>" class="pub_on">公開設定</span></li>
        </ul>
        <div class="del_field">
          <p>本当に削除しますか？</p>
          <ul>
            <li><span id="del_run<?php echo $num; ?>" class="del_run">削除を実行</span> | </li>
            <li><span id="del_cancel<?php echo $num; ?>" class="del_cancel">キャンセル</span>&nbsp;&nbsp;&nbsp;</li>
            <li><span class="del_res">&nbsp;</span></li>
          </ul>
        </div>
        <div class="pub_field">
          <p>公開設定を変更しますか？</p>
          <ul>
            <li><span id="pub_run<?php echo $num; ?>" class="pub_run"><?php echo $e_pub; ?></span> | </li>
            <li><span id="pub_cancel<?php echo $num; ?>" class="pub_cancel">キャンセル</span>&nbsp;&nbsp;&nbsp;</li>
            <li><span class="pub_res">&nbsp;</span></li>
          </ul>
        </div>
      </td>
      <td class="data_del">
        <p><?php echo $c_pub; ?></p>
      </td>
    </tr>
<?php 
$num++;
} // END for dir
?>
  </tbody>
</table>
<?php } else { ?>
<table border="0" cellpadding="0" cellspacing="0" class="folderedit_tbl data_none">
  <thead>
    <tr>
      <th class="data_dir">フォルダ名</th>
      <th class="data_name">タイトル</th>
      <th class="data_count">ファイル数</th>
      <th class="data_del">状態</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="data_none" colspan="4"><p>フォルダがありません。<br />フォルダをアップロード、または作成してください。</p></td>
    </tr>
  </tbody>
</table>
<?php } // END if dir ?>

<?php if(count($node->dir) > 0){ ?>
<div id="edit">
  <p id="editBtn" class="clearfix"><span>変更を保存</span><img src="./static/images/common/loading-circle_w_mini.gif" alt="" width="32" height="32" /></p>
  <div id="editResult">
    <p class="msg"></p>
    <p class="close"><span>閉じる</span></p>
    <br class="clear" />
  </div>
</div>
<?php } ?>

</form>

</div><!-- /#content -->

<p class="pagetop"><a href="#top">↑PAGE TOP</a></p>

<hr class="clear" />
</div><!-- /#mainBody -->

<hr class="clear" />
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->



<?php include_once("html_footer.php"); ?>



</body>
</html>