<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>フォルダを作る - Img-Portfolio</title>

<link rel="stylesheet" href="static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="static/css/base.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="static/images/common/favicon.ico" />

<script type="text/javascript" src="static/js/jquery1.5.2.min.js"></script>
<script type="text/javascript" src="static/js/ui.core.js"></script>
<script type="text/javascript" src="static/js/cookie.js"></script>
<script type="text/javascript" src="static/js/scrollfollow.js"></script>
<script type="text/javascript" src="static/js/sortable.js"></script>
<script type="text/javascript" src="static/js/common.js"></script>
<script type="text/javascript">
//<![CDATA[


jQuery().ready(function() {
  this.helpSet   = helpSet("folder_make");
  this.helpBtn   = helpBtn("folder_make");
  this.postStyle = postStyle();
  this.postEdit  = postEdit();
  return this;
}); //ready


var postStyle = function() {
  $("input.folder_name,input.folder_dir")
    .focus(function(){
      $(this).addClass("selected");
    })
    .blur(function(){
      $(this).removeClass("selected");
    });
}


var postEdit = function() {
  postBtn();
  $("#editBtn > span").bind("click",function(){
    $("#editBtn > img").css({"display":"block"});
    $("#editResult").removeClass().css({"display":"none"});
    $("#editBtn > span").unbind("click");
    $("#editBtn > span").text("保存中");
    $(".data_field > .error_item").remove();
    var folder_dir = $('#folder_dir').val();
    var folder_name = $('#folder_name').val();
    var folder_pub  = ($('#folder_pub').attr('checked'))? 1: 0;
    $.ajax({
      type: "POST",
      url: "folder-make.php",
      data: {
        "folder_dir" : folder_dir,
        "folder_name" : folder_name,
        "folder_pub"  : folder_pub
      },
      cache: false,
      dataType: "xml",
      timeout: 10000,
      error:function() {
        $("#editResult").addClass("error");
        $("#editResult > .msg").html("通信エラー！設定を変更できません。");
        $("#editResult").slideDown();
        $("#editBtn > img").css({"display":"none"});
        $("#editBtn > span").text("変更を保存");
        postEdit();
        return true;
      },
      success:function(xml) {
        var result = $(xml).find("result").text();
        if(result == 1){
          $("#editResult").addClass("complete");
          $("#editResult > .msg").html("フォルダを作成しました！<ul><li><a href=\"../\" target=\"_blank\">サイトを表示<\/a><\/li><\/ul>");
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        } else {
          $("#editResult").addClass("error");
          $("#editResult > .msg").html("エラー！設定を変更できません。");
          var obj = "";
          $(xml).find("error").each(function(i){
            var key  = $(xml).find("error").eq(i).attr("key");
            var name = $(xml).find("error").eq(i).attr("name");
            var str  = $(xml).find("error").eq(i).text();
            if(str != ""){
              $("#"+key).before("<div class='error_item'>"+ str +"<\/div>");
              obj += "<li>"+ name +"は"+ str +"<\/li>";
            }
          });
          if(obj != ""){
            $("#editResult > .msg").append("<ul>"+ obj +"<\/ul>");
          }
          $(".error_item").slideDown();
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        }
        postEdit();
        return true;
      }
    });
  });
}


//]]>
</script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea" class="clearfix">
  <h1 id="top"><a href="./"><img src="static/images/common/logo-img-portfolio.png" alt="Img-Portfolio" width="200" height="60" /></a></h1>
  <ul><li><a href="../" target="_blank">サイトを表示</a></li><li><a href="./?status=logout">ログアウト</a></li></ul>
</div><!-- /#headerArea -->
<hr class="hidden" />

<div id="mainArea" class="body-2-column">

<?php include_once("html_sidemenu.php"); ?>

<div id="mainBody">

<div id="content" class="posts">

<h2><img src="./static/images/icon/folder_make.gif" alt="" width="60" height="40" />フォルダを作る</h2>
<p class="helpBtn">[ヘルプを表示]</p>
<br class="clear" />

<div class="help">
  <p>フォルダを新規作成します。</p>
  <ul>
    <li>フォルダ名は半角英数字で入力してください。</li>
    <li>タイトルを入力することで、フォルダに日本語タイトルを付けることができます。</li>
  </ul>
</div>

<form action="folder-make.php" method="post">

<table border="0" cellpadding="0" cellspacing="0" class="foldermk_tbl">
  <tbody>
    <tr>
      <th class="data_dir">フォルダ名　<span class="must">（必須）</span>　<span class="type">[半角英数字]</span></th>
      <td class="data_dir">
        <p class="data_field">
        <input type="text" tabindex="1" name="folder_dir" id="folder_dir" value="" size="15" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th class="data_name">タイトル</th>
      <td class="data_name">
        <p class="data_field">
        <input type="text" tabindex="2" name="folder_name" id="folder_name" value="" size="30" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th class="data_name">公開設定</th>
      <td class="data_name">
        <p class="data_field">
        <input type="checkbox" tabindex="3" name="folder_pub" id="folder_pub" value="1" checked="checked" />&nbsp;フォルダを「公開」状態にする
        </p>
      </td>
    </tr>
  </tbody>
</table>

<div id="edit">
  <p id="editBtn" class="clearfix"><span>フォルダを作る</span><img src="./static/images/common/loading-circle_w_mini.gif" alt="" width="32" height="32" /></p>
  <div id="editResult">
    <p class="msg"></p>
    <p class="close"><span>閉じる</span></p>
    <br class="clear" />
  </div>
</div>

</form>

</div><!-- /#content -->

<p class="pagetop"><a href="#top">↑PAGE TOP</a></p>

<hr class="clear" />
</div><!-- /#mainBody -->

<hr class="clear" />
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->



<?php include_once("html_footer.php"); ?>



</body>
</html>