<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>2.基本設定 - インストール - Img Portfolio</title>

<link rel="stylesheet" href="admin/static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="admin/static/css/install-config.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="admin/static/images/common/favicon.ico" />

<script type="text/javascript" src="admin/static/js/jquery1.5.2.min.js"></script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea">
&nbsp;
</div><!-- /#headerArea -->
<hr class="hidden" />

<div id="mainArea" class="body-1-column">
<div id="mainBody">
<div id="content">

<h1><img src="admin/static/images/login/logo-img-portfolio.png" width="300" height="90" alt="img-portfolio" /></h1>

<div id="introduction">
  <h2>Img Porfolioインストール</h2>
  <h3>2.基本設定</h3>
  <p>サイト・Eメール・プロフィール・許可するHTMLタグの設定を行います。<br />
  「必須」は必ず入力してください。<br />
  入力完了後、「3.入力内容確認へ移動」ボタンをクリックしてください。</p>
</div>

<div id="install">
<?php 
$prof_error = array();
foreach($data as $key => $value){
 if($key != "user" || $key != "pass"){
   $prof_error[$key] = $data[$key]["error"];
 }
}
?>
<?php msg_head_error($prof_data,$prof_error,"入力エラーです"); ?>

<form action="admin/install-config.php" method="post">
<h3>サイト設定</h3>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>サイト名<span class="must">（必須）</span></th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["site_name"]["error"],"        <span>","</span><br />"); ?>
        <input type="text" tabindex="1" name="site_name" id="site_name" value="<?php echo $data["site_name"]["value"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>サイト・説明文</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["site_description"]["error"],"        <span>","</span><br />"); ?>
        <textarea tabindex="2" name="site_description" id="site_description" cols="40" rows="4"><?php echo $data["site_description"]["value"]; ?></textarea>
        </p>
        <p class="cap">WEBサイトのmeta descriptionを生成します。</p>
      </td>
    </tr>
    <tr>
      <th>サイト・キーワード</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["site_keyword"]["error"],"        <span>","</span><br />"); ?>
        <input tabindex="3" type="text" name="site_keyword" id="site_keyword" value="<?php echo $data["site_keyword"]["value"]; ?>" size="40" maxlength="80" />
        </p>
        <p class="cap">WEBサイトにmeta keywordを生成します。<br />キーワードが複数ある場合は半角カンマ「,」で区切ってください。</p>
      </td>
    </tr>
    <tr>
      <th>サイト・コピーライト</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["site_copy"]["error"],"        <span>","</span><br />"); ?>
        <input tabindex="4" type="text" name="site_copy" id="site_copy" value="<?php echo $data["site_copy"]["value"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>検索エンジン登録</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["site_robots"]["error"],"        <span>","</span><br />"); ?>
        <input type="checkbox" tabindex="5" name="site_robots" id="site_robots" value="1"<?php get_input_checked($data["site_robots"]["value"],"1"); ?> />&nbsp;このサイトを検索エンジンに登録しない
        </p>
        <p class="cap">WEBサイトのmeta robotsにnoindex,followを設定します。</p>
      </td>
    </tr>
  </tbody>
</table>

<h3>Eメール設定</h3>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>Eメール<span class="must">（必須）</span></th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["mail_name"]["error"],"        <span>","</span><br />"); ?>
        <input type="text" tabindex="6" name="mail_name" id="mail_name" value="<?php echo $data["mail_name"]["value"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィールに<br />Eメールを表示する</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["mail_disp"]["error"],"        <span>","</span><br />"); ?>
        <input type="checkbox" tabindex="7" name="mail_disp" id="mail_disp" value="1"<?php get_input_checked_def($data["mail_disp"]["value"],"1",$data["step"]["value"]); ?> />&nbsp;表示する
        </p>
      </td>
    </tr>
  </tbody>
</table>

<h3>プロフィール設定</h3>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>プロフィールを表示する</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["prof_disp"]["error"],"        <span>","</span><br />"); ?>
        <input type="checkbox" tabindex="8" name="prof_disp" id="prof_disp" value="1"<?php get_input_checked_def($data["prof_disp"]["value"],"1",$data["step"]["value"]); ?> />&nbsp;表示する
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・名前</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["prof_name"]["error"],"        <span>","</span><br />"); ?>
        <input type="text" tabindex="9" name="prof_name" id="prof_name" value="<?php echo $data["prof_name"]["value"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・説明文</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["prof_description"]["error"],"        <span>","</span><br />"); ?>
        <textarea tabindex="10" name="prof_description" id="prof_description" cols="40" rows="4"><?php echo $data["prof_description"]["value"]; ?></textarea>
        </p>
        <p class="cap">「許可するHTMLタグ」で指定したHTMタグを使用できます。</p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・twitter</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["lnk_twttr"]["error"],"        <span>","</span><br />"); ?>
        ID : <input type="text" tabindex="11" name="lnk_twttr" id="lnk_twttr" value="<?php echo $data["lnk_twttr"]["value"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・facebook</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["lnk_facebook"]["error"],"        <span>","</span><br />"); ?>
        ID : <input type="text" tabindex="12" name="lnk_facebook" id="lnk_facebook" value="<?php echo $data["lnk_facebook"]["value"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・mixi</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["lnk_mixi"]["error"],"        <span>","</span><br />"); ?>
        ID : <input type="text" tabindex="13" name="lnk_mixi" id="lnk_mixi" value="<?php echo $data["lnk_mixi"]["value"]; ?>" size="40" maxlength="80" />
        </p>
        <p class="cap">プロフィールページのURL“http://mixi.jp/show_friend.pl?id=”以降に<br />表示される数字を入力してください。</p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・BLOG</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["lnk_blog"]["error"],"        <span>","</span><br />"); ?>
        URL : <input type="text" tabindex="14" name="lnk_blog" id="lnk_blog" value="<?php echo $data["lnk_blog"]["value"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
  </tbody>
</table>

<h3>許可するHTMLタグ</h3>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>許可するHTMLタグ</th>
      <td>
        <p class="data_field">
<?php msg_item_error($data["allow_tag"]["error"],"        <span>","</span><br />"); ?>
        <input type="text" tabindex="15" name="allow_tag" id="allow_tag" value="<?php get_input_def($data["allow_tag"]["value"],$prof_data["allow_tag"]["def"],$data["step"]["value"]); ?>" size="40" maxlength="80" />
        </p>
        <p class="cap">複数のタグを入力する場合は、半角スペースで区切ってください。</p>
      </td>
    </tr>
  </tbody>
</table>

<input type="hidden" name="user" id="user" value="<?php echo $data["user"]["value"]; ?>" />
<input type="hidden" name="pass" id="pass" value="<?php echo $data["pass"]["value"]; ?>" />

<input type="hidden" name="themes_pc" id="themes_pc" value="default-white-3column" />
<input type="hidden" name="themes_mobile" id="themes_mobile" value="default-white" />
<input type="hidden" name="themes_smartphone" id="themes_smartphone" value="default-blue" />

<input type="hidden" name="step" id="step" value="<?php echo $data["step"]["value"]; ?>" />
<input type="hidden" name="status" id="status" value="<?php echo $data["status"]["value"]; ?>" />

<p class="btn right"><input type="submit" name="regist" value="3.入力内容確認へ移動&gt;&gt;" /></p>
<p class="btn left"><input type="submit" name="back" value="&lt;&lt;1.ユーザー作成へ戻る" /></p>
<br class="clear" />

</form>
</div>
</div><!-- /#content -->
</div><!-- /#mainBody -->
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->

<?php include_once("html_footer.php"); ?>

</body>
</html>