<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>基本設定 - Img-Portfolio</title>

<link rel="stylesheet" href="static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="static/css/base.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="static/images/common/favicon.ico" />

<script type="text/javascript" src="static/js/jquery1.5.2.min.js"></script>
<script type="text/javascript" src="static/js/ui.core.js"></script>
<script type="text/javascript" src="static/js/cookie.js"></script>
<script type="text/javascript" src="static/js/scrollfollow.js"></script>
<script type="text/javascript" src="static/js/common.js"></script>
<script type="text/javascript">
//<![CDATA[

jQuery().ready(function() {
  this.helpSet   = helpSet("prof_edit");
  this.helpBtn   = helpBtn("prof_edit");
  this.postEdit  = postEdit();
  this.postStyle = postStyle();
  return this;
}); //ready

var postStyle = function() {
  $("input,textarea")
    .focus(function(){
      $(this).addClass("selected");
    })
    .blur(function(){
      $(this).removeClass("selected");
    });
}

var postEdit = function() {
  postBtn();
  $("#editBtn > span").bind("click",function(){
    $("#editBtn > img").css({"display":"block"});
    $("#editResult").removeClass().css({"display":"none"});
    $("#editBtn > span").unbind("click");
    $("#editBtn > span").text("保存中");
    $(".data_field > .error_item").remove();
    var mail_name = $('input[name="mail_name"]').val();
    var mail_disp = ($('input[name="mail_disp"]').attr('checked'))? 1: 0;
    var prof_disp = ($('input[name="prof_disp"]').attr('checked'))? 1: 0;
    var prof_name = $('input[name="prof_name"]').val();
    var prof_description = $('textarea[name="prof_description"]').val();
    var lnk_twttr = $('input[name="lnk_twttr"]').val();
    var lnk_facebook = $('input[name="lnk_facebook"]').val();
    var lnk_mixi  = $('input[name="lnk_mixi"]').val();
    var lnk_blog  = $('input[name="lnk_blog"]').val();
    var site_name = $('input[name="site_name"]').val();
    var site_description = $('textarea[name="site_description"]').val();
    var site_keyword = $('input[name="site_keyword"]').val();
    var site_copy = $('input[name="site_copy"]').val();
    var site_robots = ($('input[name="site_robots"]').attr('checked'))? 1: 0;
    var allow_tag = $('input[name="allow_tag"]').val();
    var themes_pc = $('input[name="themes_pc"]').val();
    var themes_mobile = $('input[name="themes_mobile"]').val();
    var themes_smartphone = $('input[name="themes_smartphone"]').val();
    var pass_change = $('input[name="pass_change"]').val();
    var pass_check  = $('input[name="pass_check"]').val();
    $.ajax({
      type: "POST",
      url: "prof-edit.php",
      data: {
        "mail_name" : mail_name,
        "mail_disp" : mail_disp,
        "prof_disp" : prof_disp,
        "prof_name" : prof_name,
        "prof_description" : prof_description,
        "lnk_twttr" : lnk_twttr,
        "lnk_facebook" : lnk_facebook,
        "lnk_mixi"  : lnk_mixi,
        "lnk_blog"  : lnk_blog,
        "site_name" : site_name,
        "site_description" : site_description,
        "site_keyword" : site_keyword,
        "site_copy" : site_copy,
        "site_robots" : site_robots,
        "allow_tag" : allow_tag,
        "themes_pc" : themes_pc,
        "themes_mobile" : themes_mobile,
        "themes_smartphone" : themes_smartphone,
        "pass_change" : pass_change,
        "pass_check" : pass_check
      },
      cache: false,
      dataType: "xml",
      timeout: 10000,
      error:function() {
        $("#editResult").addClass("error");
        $("#editResult > .msg").html("通信エラー！設定を変更できません。");
        $("#editResult").slideDown();
        $("#editBtn > img").css({"display":"none"});
        $("#editBtn > span").text("変更を保存");
        postEdit();
        return true;
      },
      success:function(xml) {
        var result = $(xml).find("result").text();
        if(result == 1){
          $("#editResult").addClass("complete");
          $("#editResult > .msg").html("設定を変更しました！<ul><li><a href=\"../\" target=\"_blank\">サイトを表示<\/a><\/li><\/ul>");
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        } else {
          $("#editResult").addClass("error");
          $("#editResult > .msg").html("エラー！設定を変更できません。");
          var obj = "";
          $(xml).find("error").each(function(i){
            var key  = $(xml).find("error").eq(i).attr("key");
            var name = $(xml).find("error").eq(i).attr("name");
            var str  = $(xml).find("error").eq(i).text();
            if(str != ""){
              $("#"+key).before("<div class='error_item'>"+ str +"<\/div>");
              obj += "<li>"+ name +"は"+ str +"<\/li>";
            }
          });
          if(obj != ""){
            $("#editResult > .msg").append("<ul>"+ obj +"<\/ul>");
          }
          $(".error_item").slideDown();
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        }
        postEdit();
        return true;
      }
    });
  });
}

//]]>
</script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea" class="clearfix">
  <h1 id="top"><a href="./"><img src="static/images/common/logo-img-portfolio.png" alt="Img-Portfolio" width="200" height="60" /></a></h1>
  <ul><li><a href="../" target="_blank">サイトを表示</a></li><li><a href="./?status=logout">ログアウト</a></li></ul>
</div><!-- /#headerArea -->
<hr class="hidden" />

<div id="mainArea" class="body-2-column">

<?php include_once("html_sidemenu.php"); ?>

<div id="mainBody">

<div id="content" class="posts">

<h2><img src="./static/images/icon/prof_edit.gif" alt="" width="60" height="40" />基本設定</h2>
<p class="helpBtn">[ヘルプを表示]</p>
<br class="clear" />

<div class="help">
  <p>WEBサイトの基本設定を行います。</p>
  <ul>
    <li><strong>サイト設定</strong>：サイト名およびサイトの説明を設定してください。</li>
    <li><strong>Eメール設定</strong>：メールアドレスを設定してください。サイトへの表示の他、パスワードを忘れてログイン出来なくなった際にも使用します。</li>
    <li><strong>プロフィール設定</strong>：サイトに表示するプロフィールを設定してください。</li>
    <li><strong>許可するHTMLタグ</strong>：プロフィール設定の説明文および各ファイルのキャプションを入力する際に使用できるHTMLタグを指定してください。</li>
    <li><strong>パスワード変更</strong>：ログイン・パスワードを変更します。変更がある場合のみ入力ください。</li>
  </ul>
</div>

<form action="prof-edit.php" method="post">

<h3>サイト設定</h3>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>サイト名<span class="must">（必須）</span></th>
      <td>
        <p class="data_field">
        <input type="text" tabindex="1" name="site_name" id="site_name" value="<?php echo $config["site_name"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>サイト・説明文</th>
      <td>
        <p class="data_field">
        <textarea tabindex="2" name="site_description" id="site_description" cols="40" rows="4"><?php echo $config["site_description"]; ?></textarea>
        </p>
        <p class="cap">WEBサイトのmeta descriptionを生成します。</p>
      </td>
    </tr>
    <tr>
      <th>サイト・キーワード</th>
      <td>
        <p class="data_field">
        <input tabindex="3" type="text" name="site_keyword" id="site_keyword" value="<?php echo $config["site_keyword"]; ?>" size="40" maxlength="80" />
        </p>
        <p class="cap">WEBサイトにmeta keywordを生成します。<br />キーワードが複数ある場合は半角カンマ「,」で区切ってください。</p>
      </td>
    </tr>
    <tr>
      <th>サイト・コピーライト</th>
      <td>
        <p class="data_field">
        <input tabindex="4" type="text" name="site_copy" id="site_copy" value="<?php echo $config["site_copy"]; ?>" size="40" maxlength="80" />
        </p>
        <p class="cap">WEBサイトにコピーライトを表示します。</p>
      </td>
    </tr>
    <tr>
      <th>検索エンジン登録</th>
      <td>
        <p class="data_field">
        <input type="checkbox" tabindex="5" name="site_robots" id="site_robots" value="1"<?php get_input_checked($config["site_robots"],"1"); ?> />&nbsp;このサイトを検索エンジンに登録しない
        </p>
        <p class="cap">WEBサイトのmeta robotsにnoindex,followを設定します。</p>
      </td>
    </tr>
  </tbody>
</table>

<h3>Eメール設定</h3>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>Eメール<span class="must">（必須）</span></th>
      <td>
        <p class="data_field">
        <input type="text" tabindex="6" name="mail_name" id="mail_name" value="<?php echo $config["mail_name"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィールに<br />Eメールを表示する</th>
      <td>
        <p class="data_field">
        <input type="checkbox" tabindex="7" name="mail_disp" id="mail_disp" value="1"<?php get_input_checked($config["mail_disp"],"1"); ?> />&nbsp;表示する
        </p>
      </td>
    </tr>
  </tbody>
</table>

<h3>プロフィール設定</h3>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>プロフィールを表示する</th>
      <td>
        <p class="data_field">
        <input type="checkbox" tabindex="8" name="prof_disp" id="prof_disp" value="1"<?php get_input_checked($config["prof_disp"],"1"); ?> />&nbsp;表示する
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・名前</th>
      <td>
        <p class="data_field">
        <input type="text" tabindex="9" name="prof_name" id="prof_name" value="<?php echo $config["prof_name"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・説明文</th>
      <td>
        <p class="data_field">
        <textarea tabindex="10" name="prof_description" id="prof_description" cols="40" rows="4"><?php echo $config["prof_description"]; ?></textarea>
        </p>
        <p class="cap">「許可するHTMLタグ」で指定したHTMタグを使用できます。</p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・twitter</th>
      <td>
        <p class="data_field">
        ID : <input type="text" tabindex="11" name="lnk_twttr" id="lnk_twttr" value="<?php echo $config["lnk_twttr"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・facebook</th>
      <td>
        <p class="data_field">
        ID : <input type="text" tabindex="12" name="lnk_facebook" id="lnk_facebook" value="<?php echo $config["lnk_facebook"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・mixi</th>
      <td>
        <p class="data_field">
        ID : <input type="text" tabindex="13" name="lnk_mixi" id="lnk_mixi" value="<?php echo $config["lnk_mixi"]; ?>" size="40" maxlength="80" />
        </p>
        <p class="cap">プロフィールページのURL“http://mixi.jp/show_friend.pl?id=”以降に<br />表示される数字を入力してください。</p>
      </td>
    </tr>
    <tr>
      <th>プロフィール・BLOG</th>
      <td>
        <p class="data_field">
        URL : <input type="text" tabindex="14" name="lnk_blog" id="lnk_blog" value="<?php echo $config["lnk_blog"]; ?>" size="40" maxlength="80" />
        </p>
      </td>
    </tr>
  </tbody>
</table>

<h3 class="notice">許可するHTMLタグ</h3>
<p class="notice">「基本設定-プロフィール説明文」及び「ファイル編集-キャプション」入力の際に<br />許可するHTMLタグを設定します。</p>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>許可するHTMLタグ</th>
      <td>
        <p class="data_field">
        <input type="text" tabindex="15" name="allow_tag" id="allow_tag" value="<?php echo $config["allow_tag"]; ?>" size="40" maxlength="80" />
        </p>
        <p class="cap">複数のタグを入力する場合は、半角スペースで区切ってください。</p>
      </td>
    </tr>
  </tbody>
</table>

<h3 class="notice">パスワード変更</h3>
<p class="notice">※変更がある場合のみ入力ください。</p>

<table border="0" cellpadding="0" cellspacing="0" class="conf_tbl">
  <tbody>
    <tr>
      <th>パスワード変更</th>
      <td>
        <p class="data_field">
        <input type="password" tabindex="16" name="pass_change" id="pass_change" value="" size="20" maxlength="80" />
        </p>
      </td>
    </tr>
    <tr>
      <th>パスワード変更（確認）</th>
      <td>
        <p class="data_field">
        <input type="password" tabindex="17" name="pass_check" id="pass_check" value="" size="20" maxlength="80" />
        </p>
        <p class="cap">確認のためパスワード変更をもう一度入力してください。</p>
      </td>
    </tr>
  </tbody>
</table>

<input type="hidden" name="themes_pc" id="themes_pc" value="<?php echo $config["themes_pc"]; ?>" />
<input type="hidden" name="themes_mobile" id="themes_mobile" value="<?php echo $config["themes_mobile"]; ?>" />
<input type="hidden" name="themes_smartphone" id="themes_smartphone" value="<?php echo $config["themes_smartphone"]; ?>" />

<div id="edit">
  <p id="editBtn" class="clearfix"><span>変更を保存</span><img src="./static/images/common/loading-circle_w_mini.gif" alt="" width="32" height="32" /></p>
  <div id="editResult">
    <p class="msg"></p>
    <p class="close"><span>閉じる</span></p>
    <br class="clear" />
  </div>
</div>

</form>

</div><!-- /#content -->

<p class="pagetop"><a href="#top">↑PAGE TOP</a></p>

<hr class="clear" />
</div><!-- /#mainBody -->

<hr class="clear" />
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->



<?php include_once("html_footer.php"); ?>



</body>
</html>