<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>テーマ選択 - Img-Portfolio</title>

<link rel="stylesheet" href="static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="static/css/base.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="static/images/common/favicon.ico" />

<script type="text/javascript" src="static/js/jquery1.5.2.min.js"></script>
<script type="text/javascript" src="static/js/ui.core.js"></script>
<script type="text/javascript" src="static/js/cookie.js"></script>
<script type="text/javascript" src="static/js/scrollfollow.js"></script>
<script type="text/javascript" src="static/js/common.js"></script>
<script type="text/javascript">
//<![CDATA[

jQuery().ready(function() {
  this.helpSet   = helpSet("prof_theme");
  this.helpBtn   = helpBtn("prof_theme");
  this.postEdit  = postEdit();
  this.postStyle = postStyle();
  return this;
}); //ready

var postStyle = function() {
  $("input,textarea")
    .focus(function(){
      $(this).addClass("selected");
    })
    .blur(function(){
      $(this).removeClass("selected");
    });
}

var postEdit = function() {
  postBtn();
  $("#editBtn > span").bind("click",function(){
    $("#editBtn > img").css({"display":"block"});
    $("#editResult").removeClass().css({"display":"none"});
    $("#editBtn > span").unbind("click");
    $("#editBtn > span").text("保存中");
    $(".data_field > .error_item").remove();
    var mail_name = $('input[name="mail_name"]').val();
    var mail_disp = $('input[name="mail_disp"]').val();
    var prof_disp = $('input[name="prof_disp"]').val();
    var prof_name = $('input[name="prof_name"]').val();
    var prof_description = $('input[name="prof_description"]').val();
    var lnk_twttr = $('input[name="lnk_twttr"]').val();
    var lnk_facebook = $('input[name="lnk_facebook"]').val();
    var lnk_mixi  = $('input[name="lnk_mixi"]').val();
    var lnk_blog  = $('input[name="lnk_blog"]').val();
    var site_name = $('input[name="site_name"]').val();
    var site_description = $('input[name="site_description"]').val();
    var site_keyword = $('input[name="site_keyword"]').val();
    var site_copy = $('input[name="site_copy"]').val();
    var site_robots = $('input[name="site_robots"]').val();
    var allow_tag = $('input[name="allow_tag"]').val();
    var themes_pc = $('input[name="themes_pc"]:checked').val();
    var themes_mobile = $('input[name="themes_mobile"]:checked').val();
    var themes_smartphone = $('input[name="themes_smartphone"]:checked').val();
    $.ajax({
      type: "POST",
      url: "prof-edit.php",
      data: {
        "mail_name" : mail_name,
        "mail_disp" : mail_disp,
        "prof_disp" : prof_disp,
        "prof_name" : prof_name,
        "prof_description" : prof_description,
        "lnk_twttr" : lnk_twttr,
        "lnk_facebook" : lnk_facebook,
        "lnk_mixi"  : lnk_mixi,
        "lnk_blog"  : lnk_blog,
        "site_name" : site_name,
        "site_description" : site_description,
        "site_keyword" : site_keyword,
        "site_copy" : site_copy,
        "site_robots" : site_robots,
        "allow_tag" : allow_tag,
        "themes_pc" : themes_pc,
        "themes_mobile" : themes_mobile,
        "themes_smartphone" : themes_smartphone
      },
      cache: false,
      dataType: "xml",
      timeout: 10000,
      error:function() {
        $("#editResult").addClass("error");
        $("#editResult > .msg").html("通信エラー！設定を変更できません。");
        $("#editResult").slideDown();
        $("#editBtn > img").css({"display":"none"});
        $("#editBtn > span").text("変更を保存");
        postEdit();
        return true;
      },
      success:function(xml) {
        var result = $(xml).find("result").text();
        if(result == 1){
          $("#editResult").addClass("complete");
          $("#editResult > .msg").html("設定を変更しました！<ul><li><a href=\"../\" target=\"_blank\">サイトを表示<\/a><\/li><\/ul>");
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        } else {
          $("#editResult").addClass("error");
          $("#editResult > .msg").html("エラー！設定を変更できません。");
          var obj = "";
          $(xml).find("error").each(function(i){
            var key  = $(xml).find("error").eq(i).attr("key");
            var name = $(xml).find("error").eq(i).attr("name");
            var str  = $(xml).find("error").eq(i).text();
            if(str != ""){
              $("#"+key).before("<div class='error_item'>"+ str +"<\/div>");
              obj += "<li>"+ name +"は"+ str +"<\/li>";
            }
          });
          if(obj != ""){
            $("#editResult > .msg").append("<ul>"+ obj +"<\/ul>");
          }
          $(".error_item").slideDown();
          $("#editResult").slideDown();
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("変更を保存");
        }
        postEdit();
        return true;
      }
    });
  });
}

//]]>
</script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea" class="clearfix">
  <h1 id="top"><a href="./"><img src="static/images/common/logo-img-portfolio.png" alt="Img-Portfolio" width="200" height="60" /></a></h1>
  <ul><li><a href="../" target="_blank">サイトを表示</a></li><li><a href="./?status=logout">ログアウト</a></li></ul>
</div><!-- /#headerArea -->
<hr class="hidden" />

<div id="mainArea" class="body-2-column">

<?php include_once("html_sidemenu.php"); ?>

<div id="mainBody">

<div id="content" class="posts">

<h2><img src="./static/images/icon/prof_theme.gif" alt="" width="60" height="40" />テーマ選択</h2>
<p class="helpBtn">[ヘルプを表示]</p>
<br class="clear" />

<div class="help">
  <p>WEBサイトで使用するデザイン・テーマを選択します。</p>
  <ul>
    <li>PC・携帯・スマートフォン（iPhone / Android）の各テーマを設定してください。</li>
    <li>各テーマのデータは「theme」ディレクトリ以下に格納されています。</li>
    <li>選択したテーマの詳細設定は各テーマ・ディレクトリ内の「theme.config.php」で変更できます。</li>
  </ul>
</div>

<form action="prof-edit.php" method="post">

<input type="hidden" name="site_name" id="site_name" value="<?php echo $config["site_name"]; ?>" />
<input type="hidden" name="site_description" id="site_description" value="<?php echo $config["site_description"]; ?>" />
<input type="hidden" name="site_keyword" id="site_keyword" value="<?php echo $config["site_keyword"]; ?>" />
<input type="hidden" name="site_copy" id="site_copy" value="<?php echo $config["site_copy"]; ?>" />
<input type="hidden" name="site_robots" id="site_robots" value="<?php echo $config["site_robots"]; ?>" />
<input type="hidden" name="mail_name" id="mail_name" value="<?php echo $config["mail_name"]; ?>" />
<input type="hidden" name="mail_disp" id="mail_disp" value="<?php echo $config["mail_disp"]; ?>" />
<input type="hidden" name="prof_disp" id="prof_disp" value="<?php echo $config["prof_disp"]; ?>" />
<input type="hidden" name="prof_name" id="prof_name" value="<?php echo $config["prof_name"]; ?>" />
<input type="hidden" name="prof_description" id="prof_description" value="<?php echo $config["prof_description"]; ?>" />
<input type="hidden" name="lnk_twttr" id="lnk_twttr" value="<?php echo $config["lnk_twttr"]; ?>" />
<input type="hidden" name="lnk_facebook" id="lnk_facebook" value="<?php echo $config["lnk_facebook"]; ?>" />
<input type="hidden" name="lnk_mixi" id="lnk_mixi" value="<?php echo $config["lnk_mixi"]; ?>" />
<input type="hidden" name="lnk_blog" id="lnk_blog" value="<?php echo $config["lnk_blog"]; ?>" />
<input type="hidden" name="allow_tag" id="allow_tag" value="<?php echo $config["allow_tag"]; ?>" />

<h3>PC・テーマ選択</h3>

<table border="0" cellpadding="0" cellspacing="0" class="theme_tbl">
  <tbody>
    <tr>
      <th class="data_image">サムネイル</th>
      <th>タイトル</th>
      <th class="data_select">選択</th>
    </tr>
<?php get_input_themes(16,$config_theme_pc,$config["themes_pc"],"themes_pc"); ?>
  </tbody>
</table>

<h3>携帯・テーマ選択</h3>

<table border="0" cellpadding="0" cellspacing="0" class="theme_tbl">
  <tbody>
    <tr>
      <th class="data_image">サムネイル</th>
      <th>タイトル</th>
      <th class="data_select">選択</th>
    </tr>
<?php $count_pc1 = count($config_theme_pc) + 16; ?>
<?php get_input_themes($count_pc1,$config_theme_mobile,$config["themes_mobile"],"themes_mobile"); ?>
  </tbody>
</table>

<h3>スマートフォン（iPhone / Android）・テーマ選択</h3>

<table border="0" cellpadding="0" cellspacing="0" class="theme_tbl">
  <tbody>
    <tr>
      <th class="data_image">サムネイル</th>
      <th>タイトル</th>
      <th class="data_select">選択</th>
    </tr>
<?php $count_pc2 = count($config_theme_mobile) + $count_pc1; ?>
<?php get_input_themes($count_pc2,$config_theme_smartphone,$config["themes_smartphone"],"themes_smartphone"); ?>
  </tbody>
</table>

<div id="edit">
  <p id="editBtn" class="clearfix"><span>変更を保存</span><img src="./static/images/common/loading-circle_w_mini.gif" alt="" width="32" height="32" /></p>
  <div id="editResult">
    <p class="msg"></p>
    <p class="close"><span>閉じる</span></p>
    <br class="clear" />
  </div>
</div>

</form>

</div><!-- /#content -->

<p class="pagetop"><a href="#top">↑PAGE TOP</a></p>

<hr class="clear" />
</div><!-- /#mainBody -->

<hr class="clear" />
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->



<?php include_once("html_footer.php"); ?>



</body>
</html>