<?php require_once("tmpl.function.php"); ?>
<?php echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"."\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />

<meta name="robots" content="noindex,nofollow" />

<title>プロフィール画像 - Img-Portfolio</title>

<link rel="stylesheet" href="static/css/common/import.css" type="text/css" media="screen,print,tv" />
<link rel="stylesheet" href="static/css/base.css" type="text/css" media="screen,print,tv" />

<link rel="shortcut icon" href="static/images/common/favicon.ico" />

<script type="text/javascript" src="static/js/jquery1.5.2.min.js"></script>
<script type="text/javascript" src="static/js/ui.core.js"></script>
<script type="text/javascript" src="static/js/cookie.js"></script>
<script type="text/javascript" src="static/js/scrollfollow.js"></script>
<script type="text/javascript" src="static/js/ajaxfileupload.js"></script>
<script type="text/javascript" src="static/js/common.js"></script>
<script type="text/javascript">
//<![CDATA[

jQuery().ready(function() {
  this.helpSet   = helpSet("prof_upload");
  this.helpBtn   = helpBtn("prof_upload");
  this.postEdit  = postEdit();
  return this;
}); //ready

var postImage = function(image_url) {
  var now = (new Date()).getTime();
  var image_data = new Image();
  image_data.src = image_url +"?"+ now;
  $(".data_image > img").attr("src",image_data.src);
}

var loadingImage = function() {
  var image_icon = new Image();
  image_icon.src = "static/images/common/loading-circle-150_g.gif";
  $(".data_image > img").attr("src",image_icon.src);
}

var postEdit = function() {
  postBtn();
  $("#editBtn > span").bind("click",function(){
    $("#editBtn > img").css({"display":"block"});
    var image_url = $(".data_image > img").attr("src");
    var prof_image = $('input[name="prof_image"]').val();
    $("#editResult").removeClass().css({"display":"none"});
    $("#editBtn > span").unbind("click");
    $("#editBtn > span").text("アップロード中");
    loadingImage();
    $(".data_field > .error_item").remove();
    $.ajaxFileUpload({
      url: "prof-upload.php",
      secureuri: false,
      fileElementId: "prof_image",
      dataType: "xml",
      timeout: 100000,
      error: function() {
        $("#editResult").addClass("error");
        $("#editResult > .msg").html("通信エラー！アップロードできません。");
        $("#editResult").slideDown();
        $("#editBtn > img").css({"display":"none"});
        $("#editBtn > span").text("アップロード");
        postImage(image_url);
        postEdit();
        return true;
      },
      success: function(xml) {
        var result    = $(xml).find("result").text();
        var image_url = $(xml).find("filepath").text();
        postImage(image_url);
        if(result == 1){
          $("#editResult").addClass("complete");
          $("#editResult > .msg").html("アップロードしました！<ul><li><a href=\"../\" target=\"_blank\">サイトを表示<\/a><\/li><\/ul>");
          $("#editResult").slideDown("normal",function(){
	          postEdit();
	        });
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("アップロード");
	        $("#prof_image").attr("value","");
        } else {
          $("#editResult").addClass("error");
          $("#editResult > .msg").html("エラー！アップロードできません。");
          var obj = "";
          $(xml).find("error").each(function(i){
            var key  = $(xml).find("error").eq(i).attr("key");
            var str  = $(xml).find("error").eq(i).text();
            if(str != ""){
              $("#"+key).before("<div class='error_item'>"+ str +"<\/div>");
              obj += "<li>"+ str +"<\/li>";
            }
          });
          if(obj != ""){
            $("#editResult > .msg").append("<ul>"+ obj +"<\/ul>");
          }
          $(".error_item").slideDown();
          $("#editResult").slideDown("normal",function(){
	          postEdit();
	        });
          $("#editBtn > img").css({"display":"none"});
          $("#editBtn > span").text("アップロード");
        }
        return true;
      }
    });
  });
}

//]]>
</script>

</head>
<body>

<div id="wrapper">
<div id="container">

<div id="headerArea" class="clearfix">
  <h1 id="top"><a href="./"><img src="static/images/common/logo-img-portfolio.png" alt="Img-Portfolio" width="200" height="60" /></a></h1>
  <ul><li><a href="../index.php" target="_blank">サイトを表示</a></li><li><a href="./?status=logout">ログアウト</a></li></ul>
</div><!-- /#headerArea -->
<hr class="hidden" />



<div id="mainArea" class="body-2-column">

<?php include_once("html_sidemenu.php"); ?>

<div id="mainBody">

<div id="content" class="posts">

<form action="prof-upload.php" method="post" enctype="multipart/form-data">

<h2><img src="./static/images/icon/prof_upload.gif" alt="" width="60" height="40" />プロフィール画像設定</h2>
<p class="helpBtn">[ヘルプを表示]</p>
<br class="clear" />

<div class="help">
  <p>プロフィール用の画像ファイルをアップロードします。</p>
  <ul>
    <li>アップロードできるファイルはgif/jpeg/pngです。</li>
    <li>表示サイズは横150ピクセルとなります。</li>
    <li>新規に画像をアップロードした場合、以前の画像は自動で削除されます。</li>
  </ul>
</div>

<table border="0" cellpadding="0" cellspacing="0" class="profup_tbl">
  <tbody>
    <tr>
      <th class="data_image"><?php get_prof_image("../".PATH_DIR_PROF,PATH_FILE_PROF); ?></th>
      <td>
        <fieldset>
          <legend>アップロードするファイルを指定</legend>
          <p class="data_field">
          <input type="file" tabindex="1" name="prof_image" id="prof_image" size="40" />
          </p>
          <p class="cap">アップロードできるファイルの上限は<span><?php echo ini_get('upload_max_filesize'); ?></span>です</p>
        </fieldset>
      </td>
    </tr>
  </tbody>
</table>

<div id="edit">
  <p id="editBtn" class="clearfix"><span>アップロード</span><img src="./static/images/common/loading-circle_w_mini.gif" alt="" width="32" height="32" /></p>
  <div id="editResult">
    <p class="msg"></p>
    <p class="close"><span>閉じる</span></p>
    <br class="clear" />
  </div>
</div>

</form>

</div><!-- /#content -->

<p class="pagetop"><a href="#top">↑PAGE TOP</a></p>

<hr class="clear" />
</div><!-- /#mainBody -->

<hr class="clear" />
</div><!-- /#mainArea -->

</div><!-- /#container -->
</div><!-- /#wrapper -->



<?php include_once("html_footer.php"); ?>



</body>
</html>