<?php

// サイトのURLを取得
function get_site_url(){
  $protocol = (CONF_USE_SSL)? "https://": "http://";
  if(!CONF_USE_SHEAREDSSL){
    $url = $protocol.SITE_URL;
  } else {
    $url = $protocol.CONF_URL_SHEAREDSSL;
  }
  return $url;
}


// inputにselectedを追加
function get_input_selected($target,$str){
  if($target !== ""){
    $values = explode(",",$target);
    $obj = '';
    foreach($values as $value){
      if($value === $str){
        $obj = ' selected="selected"';
        break;
      }
    }
    echo $obj;
  }
  return false;
}

// inputにcheckedを追加
function get_input_checked($target,$str){
  if($target !== ""){
    $values = explode(",",$target);
    $obj = '';
    foreach($values as $value){
      if($value === $str){
        $obj = ' checked="checked"';
        break;
      }
    }
    echo $obj;
  }
  return false;
}

// input（チェックボックス）が初期の場合はcheckedをセット
function get_input_checked_def($target,$str,$step){
  $obj = '';
  if($step === ""){
    $values = explode(",",$target);
    foreach($values as $value){
      $obj = ' checked="checked"';
    }
  } elseif($target !== ""){
    $values = explode(",",$target);
    foreach($values as $value){
      if($value === $str){
        $obj = ' checked="checked"';
        break;
      }
    }
  }
  echo $obj;
}

// input（テキストボックス）が初期の場合はデフォルト値をセット
function get_input_def($target,$str,$step){
  $obj = '';
  if($step !== ""){
    $obj = $target;
  } else {
    $obj = $str;
  }
  echo $obj;
}

// テーマ選択用input（radio）
function get_input_themes($num,$theme,$theme_checked,$name){
  $obj = '';
  foreach($theme as $key => $value){
    $checked_td = ($theme_checked === $key)? ' checked': '';
    $obj .= '<tr>'."\n";
    $obj .= '<td class="data_image'.$checked_td.' ">'."\n";
    $obj .= '<img src="'.$value["thumb"].'" alt="'.$key.'" />'."\n";
    $obj .= '</td>'."\n";
    $obj .= '<td class="data_body'.$checked_td.'">'."\n";
    $obj .= '<p>'.$key."</p>\n";
    $obj .= '<ul>'."\n";
    $obj .= '<li class="description">'.$value["description"].'</li>'."\n";
    if($value["version"] !== ""){
      $obj .= '<li>バージョン : '.$value["version"].'</li>'."\n";
    }
    if($value["path"] != ""){
      $obj .= '<li>テーマのパス : '.$value["path"].'</li>'."\n";
    }
    if($value["sample_uri"] != ""){
      $obj .= '<li>サンプル : <a href="'.$value["sample_uri"].'" target="_blank">'.$value["sample_uri"].'</a></li>'."\n";
    }
    $obj .= '</ul>'."\n";
    $obj .= '</td>'."\n";
    $obj .= '<td class="data_select'.$checked_td.'">'."\n";
    $checked_input = ($theme_checked === $key)? ' checked="checked"': '';
    $obj .= '<input type="radio" tabindex="'.$num.'" name="'.$name.'" value="'.$key.'"'.$checked_input.' /> '."\n";
    $obj .= '</td>'."\n";
    $obj .= '</tr>'."\n";
    $num++;
  }
  echo $obj;
}

// classにcheckedを追加
function get_class_checked($target,$str){
  if($target !== ""){
    $values = explode(",",$target);
    $obj = '';
    foreach($values as $value){
      if($value === $str){
        $obj = ' class="selected"';
        break;
      }
    }
    echo $obj;
  }
  return false;
}

// プロフィール画像取得
function get_prof_image($path,$filename){
  $obj = "";
  $value = "";
  $arr = array(".gif",".GIF",".jpeg",".JPEG",".jpg",".JPG",".png",".PNG");
  for($i = 0; $i < count($arr); $i++){
    if(is_file($path.$filename.$arr[$i])){
      $value = $path.$filename.$arr[$i];
    }
  }
  if($value != ""){
    list(,,$type,) = getimagesize($value);
    if ($type < 4){
      $obj .= '<img src="'.$value.'" alt="prof-image" width="150" />';
    }
  }
  echo $obj;
}


// エラーテキスト表示（個別）
function msg_item_error($str,$tmpl_pre="",$tmpl_back=""){
  if($str != null){
    $obj = $tmpl_pre."<span class=\"error\">".$str."</span>".$tmpl_back."\n"; 
    echo $obj;
    return true;
  }
  return false;
}

// エラーテキスト表示（全体）
function msg_head_error($prof_data,$data_error,$msg){
  $obj = "";
  if($data_error != null && is_array($data_error)){
    foreach($data_error as $key => $value){
      if($data_error[$key] != null){
        $obj .= "<li>".$prof_data[$key]["name"]."は".$data_error[$key]."</li>\n";
      }
    }
    if($obj !== ""){
      $obj = "<div class=\"error\"><p>".$msg."</p>\n<ul>\n".$obj."</ul>\n</div>\n"; 
    }
    echo $obj;
    return true;
  }
  return false;
}

// エラーテキスト表示（全体）
function msg_head_complete($data_complete,$msg){
  $obj = '';
  if($data_complete == true){
    $obj = "<div class=\"complete\"><p>".$msg."</p></div>\n"; 
    echo $obj;
    return true;
  }
  return false;
}

?>