<?php

//ディレクトリ・ファイルリスト出力
class item_node {

  //メンバ宣言
  var $dirName;
  var $dirPath;
  var $csvDirPath;
  var $csvFilesPath;
  var $typeName;
  var $allowTag;
  var $escpTag;

  //コンストラクタ宣言
  function item_node($dirName,$dirPath,$csvDirPath,$csvFilesPath,$allowTag,$escpTag=false) {
    $this->dirName  = $dirName;
    $this->dirPath  = $dirPath;
    $this->csvDirPath   = $csvDirPath;
    $this->csvFilesPath = $csvFilesPath;
    $this->typeName = array("","GIF","JPEG","PNG");
    $this->allowTag = $allowTag;
    $this->escpTag  = $escpTag;
    $this->list_file();
  }

  //メソッド宣言
  public function list_file() {
    $this->file_sort(); //全ディレクトリをソート
    $this->dir_sort();  //CSVを参照してディレクトリをソート
  }

  public function dir_sort() {

    //ディレクトリを配列に格納
    $dirList  = $this->get_dir_list();

    //ディレクトリ内のファイルを配列に格納
    $fileList = $this->get_file_list($dirList);

    //ディレクトリ内の画像ファイルを配列に格納
    $imgList  = $this->check_file_image($dirList,$fileList);

    //ディレクトリとファイルの配列をマージ
    $list = array();
    for($i = 0; $i < count($dirList); $i++){
      $list[$i]["dir"]   = $dirList[$i];
      $list[$i]["total"] = count($imgList[$i]);
      $list[$i]["data"]  = array();
      for($j = 0; $j < count($imgList[$i]); $j++){
        $list[$i]["data"][$j] = array();
        $list[$i]["data"][$j]["name"] = $imgList[$i][$j];
      }
    }

    //ディレクトリCSV読込＆ディレクトリが存在しない行を排除
    $csvDir   = $this->marge_csv_dir($this->get_csv_dir(),$dirList);

    //ファイルCSVを読込
    $csvFile  = $this->get_csv_files();

    //ディレクトリCSVを参照して配列をソート
    $data = array();
    $dnum = array();
    for($i = 0; $i < count($list); $i++){
      $flg = false;
      for($j = 0; $j < count($csvDir); $j++){
        if($list[$i]["dir"]  == $csvDir[$j]["dir"]){
          $data[$j]["dir"]   = $csvDir[$j]["dir"];
          $data[$j]["pub"]   = $csvDir[$j]["pub"];
          $data[$j]["name"]  = ($csvDir[$j]["name"] != "")? $csvDir[$j]["name"]: $list[$i]["dir"];
          $data[$j]["total"] = $list[$i]["total"];
          $data[$j]["path"]  = $this->dirPath.$list[$i]["dir"]."/";
          $data[$j]["data"]  = $list[$i]["data"];
          $data[$j]["file"]  = array();
          $flg = true;
          break;
        }
      }
      if(!$flg){
        $dnum[] = $i;
      }
    }
    ksort($data); //キーと値の関係を保持しつつ連想配列をソート

    //ディレクトリCSVに無いディレクトリを後置
    $num = 0;
    for($i = count($data); $i <= count($list); $i++){
      $j = $dnum[$num];
      if($list[$j]["dir"] != ""){
        $data[$i]["dir"]   = $list[$j]["dir"];
        $data[$i]["pub"]   = "1";
        $data[$i]["name"]  = $list[$j]["dir"];
        $data[$i]["total"] = $list[$j]["total"];
        $data[$i]["path"]  = $this->dirPath.$list[$j]["dir"]."/";
        $data[$i]["data"]  = $list[$j]["data"];
        $data[$i]["file"]  = array();
      }
      $num++;
    }

    //ファイルCSVを参照して配列をソート
    $farr = array();
    for($i = 0; $i < count($data); $i++){
      $farr[$i] = array();
      $fnum[$i] = array();
      for($j = 0; $j < count($data[$i]["data"]); $j++){
        $flg = false;
        for($k = 0; $k < count($csvFile); $k++){
          if($data[$i]["dir"] == $csvFile[$k]["dir"] && $data[$i]["data"][$j]["name"] == $csvFile[$k]["name"]) {
            list($width,$height,$type,) = getimagesize($data[$i]["path"].$csvFile[$k]["name"]);
            $body = $csvFile[$k]["body"];
            if($this->escpTag){
              $tag  = explode(" ", $this->allowTag);
              $body = $this->html_escp($body,$tag);
            }
            $farr[$i][$k]["name"] = $this->url_enc($csvFile[$k]["name"]);
            $farr[$i][$k]["body"] = $body;
            $farr[$i][$k]["path"]   = $data[$i]["path"].$this->url_enc($csvFile[$k]["name"]);
            $farr[$i][$k]["code"]   = mb_detect_encoding($csvFile[$k]["name"]);
            $farr[$i][$k]["width"]  = $width;
            $farr[$i][$k]["height"] = $height;
            $farr[$i][$k]["type"]   = $type;
            $farr[$i][$k]["ext"]    = $this->typeName[$type];
            $farr[$i][$k]["date"]   = date("Y/m/d H:i",filemtime($data[$i]["path"].$csvFile[$k]["name"]));
            $farr[$i][$k]["bool"] = true;
            $flg = true;
            break;
          }
        }
        if(!$flg){
          $fnum[$i][] = $j;
        }
      }
      ksort($farr[$i]); //キーと値の関係を保持しつつ連想配列をソート
      foreach ($farr[$i] as $data[$i]["file"][]){}

      //ファイルCSVに無いファイルを後置
      $num = 0;
      for($l = count($farr[$i]); $l < count($data[$i]["data"]); $l++){
        $f = $fnum[$i][$num];
        list($width,$height,$type,)   = getimagesize($data[$i]["path"].$this->url_enc($data[$i]["data"][$f]["name"]));
        $data[$i]["file"][$l]["name"] = $this->url_enc($data[$i]["data"][$f]["name"]);
        $data[$i]["file"][$l]["body"] = "";
        $data[$i]["file"][$l]["path"]   = $data[$i]["path"].$this->url_enc($data[$i]["data"][$f]["name"]);
        $data[$i]["file"][$l]["code"]   = mb_detect_encoding($data[$i]["data"][$f]["name"]);
        $data[$i]["file"][$l]["width"]  = $width;
        $data[$i]["file"][$l]["height"] = $height;
        $data[$i]["file"][$l]["type"]   = $type;
        $data[$i]["file"][$l]["ext"]    = $this->typeName[$type];
        $data[$i]["file"][$l]["date"]   = date("Y/m/d H:i",filemtime($data[$i]["path"].$data[$i]["data"][$f]["name"]));
        $data[$i]["file"][$l]["bool"] = true;
        $num++;
      }

      unset($data[$i]["data"]);
    }

    $this->dir = $data;
  }

  public function file_sort() {

    //ディレクトリを配列に格納
    $getDirList  = $this->get_dir_list();

    //ディレクトリ内のファイルを配列に格納
    $getFileList = $this->get_file_list($getDirList);

    //ディレクトリ内の画像ファイルの有無をチェック、無い場合はディレクトリ配列から除外
    $dirList     = $this->check_dir_image($getDirList,$getFileList);

    //画像が存在するディレクトリ内のファイルを配列に格納
    $fileList    = $this->get_file_list($dirList);

    //ディレクトリ内の画像ファイルを配列に格納
    $imgList  = $this->check_file_image($dirList,$fileList);

    //ディレクトリとファイルの配列をマージ
    $list = array();
    for($i = 0; $i < count($dirList); $i++){
      $list[$i]["dir"]   = $dirList[$i];
      $list[$i]["total"] = count($imgList[$i]);
      $list[$i]["data"]  = array();
      for($j = 0; $j < count($imgList[$i]); $j++){
        $list[$i]["data"][$j] = array();
        $list[$i]["data"][$j]["name"] = $imgList[$i][$j];
      }
    }

    //ディレクトリCSV読込＆ディレクトリが存在しない行を排除
    $csvDir   = $this->marge_csv_dir($this->get_csv_dir(),$dirList);

    //ファイルCSVを読込
    $csvFile  = $this->get_csv_files();

    //ディレクトリCSVを参照して配列をソート
    $data = array();
    $dnum = array();
    for($i = 0; $i < count($list); $i++){
      $flg = false;
      for($j = 0; $j < count($csvDir); $j++){
        if($list[$i]["dir"]  == $csvDir[$j]["dir"] && $list[$i]["total"] !== 0){
          $data[$j]["dir"]   = $csvDir[$j]["dir"];
          $data[$j]["pub"]   = $csvDir[$j]["pub"];
          $data[$j]["name"]  = ($csvDir[$j]["name"] != "")? $csvDir[$j]["name"]: $list[$i]["dir"];
          $data[$j]["total"] = $list[$i]["total"];
          $data[$j]["path"]  = $this->dirPath.$list[$i]["dir"]."/";
          $data[$j]["data"]  = $list[$i]["data"];
          $data[$j]["file"]  = array();
          $flg = true;
          break;
        } else if($list[$i]["dir"]  == $csvDir[$j]["dir"] && $list[$i]["total"] === 0) {
          $flg = true;
          break;
        }
      }
      if(!$flg){
        $dnum[] = $i;
      }
    }
    ksort($data); //キーと値の関係を保持しつつ連想配列をソート

    //ディレクトリCSVに無いディレクトリを後置
    $num = 0;
    for($i = count($data); $i <= count($list); $i++){
      $j = $dnum[$num];
      if($list[$j]["dir"] != ""){
        $data[$i]["dir"]   = $list[$j]["dir"];
        $data[$i]["pub"]   = "1";
        $data[$i]["name"]  = $list[$j]["dir"];
        $data[$i]["total"] = $list[$j]["total"];
        $data[$i]["path"]  = $this->dirPath.$list[$j]["dir"]."/";
        $data[$i]["data"]  = $list[$j]["data"];
        $data[$i]["file"]  = array();
      }
      $num++;
    }

    //ファイルCSVを参照して配列をソート
    $farr = array();
    for($i = 0; $i < count($data); $i++){
      $farr[$i] = array();
      $fnum[$i] = array();
      for($j = 0; $j < count($data[$i]["data"]); $j++){
        $flg = false;
        for($k = 0; $k < count($csvFile); $k++){
          if($data[$i]["dir"] == $csvFile[$k]["dir"] && $data[$i]["data"][$j]["name"] == $csvFile[$k]["name"]) {
            list($width,$height,$type,) = getimagesize($data[$i]["path"].$csvFile[$k]["name"]);
            $body = $csvFile[$k]["body"];
            if($this->escpTag){
              $tag  = explode(" ", $this->allowTag);
              $body = $this->html_escp($body,$tag);
            }
            $farr[$i][$k]["name"] = $this->url_enc($csvFile[$k]["name"]);
            $farr[$i][$k]["body"] = $body;
            $farr[$i][$k]["path"]   = $data[$i]["path"].$this->url_enc($csvFile[$k]["name"]);
            $farr[$i][$k]["code"]   = mb_detect_encoding($csvFile[$k]["name"]);
            $farr[$i][$k]["width"]  = $width;
            $farr[$i][$k]["height"] = $height;
            $farr[$i][$k]["type"]   = $type;
            $farr[$i][$k]["ext"]    = $this->typeName[$type];
            $farr[$i][$k]["date"]   = date("Y/m/d H:i",filemtime($data[$i]["path"].$csvFile[$k]["name"]));
            $farr[$i][$k]["bool"] = true;
            $flg = true;
            break;
          }
        }
        if(!$flg){
          $fnum[$i][] = $j;
        }
      }
      ksort($farr[$i]); //キーと値の関係を保持しつつ連想配列をソート
      foreach ($farr[$i] as $data[$i]["file"][]){}

      //ファイルCSVに無いファイルを後置
      $num = 0;
      for($l = count($farr[$i]); $l < count($data[$i]["data"]); $l++){
        $f = $fnum[$i][$num];
        list($width,$height,$type,)   = getimagesize($data[$i]["path"].$this->url_enc($data[$i]["data"][$f]["name"]));
        $data[$i]["file"][$l]["name"] = $this->url_enc($data[$i]["data"][$f]["name"]);
        $data[$i]["file"][$l]["body"] = "";
        $data[$i]["file"][$l]["path"]   = $data[$i]["path"].$this->url_enc($data[$i]["data"][$f]["name"]);
        $data[$i]["file"][$l]["code"]   = mb_detect_encoding($data[$i]["data"][$f]["name"]);
        $data[$i]["file"][$l]["width"]  = $width;
        $data[$i]["file"][$l]["height"] = $height;
        $data[$i]["file"][$l]["type"]   = $type;
        $data[$i]["file"][$l]["ext"]    = $this->typeName[$type];
        $data[$i]["file"][$l]["date"]   = date("Y/m/d H:i",filemtime($data[$i]["path"].$data[$i]["data"][$f]["name"]));
        $data[$i]["file"][$l]["bool"] = true;
        $num++;
      }

      unset($data[$i]["data"]);
    }


    $res = array();
    foreach($data as $key => $item){
      if((bool)$item["pub"] == true){
        $res[] = $item;
      }
    }

    $this->file = $res;
  }

  // 許可したhtmlタグだけエスケープせず出力
  private function html_escp($str,$tag = array()){
    if (count($tag) == 0 ) return $str;
    foreach($tag as $key => $item) {
      if (strpos($item, '/') === false) {
        $str = preg_replace_callback("/&lt;\/?". $item . "( .*?&gt;|\/?&gt;)/i","html_unescp", $str);
      }
    }
    return $str;
  }

  //文字列エンコーディング
  private function url_enc($value,$code="UTF-8") {
    if (mb_strlen($value) != strlen($value)){
      $result = $value;
    } else {
      //$result = urlencode(convert_enc($value,$code));
      $result = convert_enc($value,$code);
    }
    return $result;
  }

  //ディレクトリを配列に格納
  private function get_dir_list() {
    $dirList = array();
    $dirItem = scandir($this->dirPath);
    foreach($dirItem as $value) {
      if (is_dir($this->dirPath.$value) && $value != "." && $value != ".." && preg_match("/^[!-~]+$/", $value)){
        array_push($dirList, $value);
      }
    }
    return $dirList;
  }

  //ファイルを配列に格納
  private function get_file_list($dirList) {
    $fileList = array();
    for($i=0; $i<count($dirList); $i++){
      $fileList[$i] = scandir($this->dirPath.$dirList[$i]);
    }
    return $fileList;
  }

  //ディレクトリ内の画像ファイルの有無をチェック、無い場合はディレクトリ配列から除外
  private function check_dir_image($dirList_orgn,$fileList) {
    $flg     = array();
    $dirList = array();
    for($i=0; $i<count($fileList); $i++){
      foreach($fileList[$i] as $value) {
        //if ($value != "." && $value != ".." && preg_match("/^[!-~]+$/", $value) && Eregi('jpg$', $value) || Eregi('jpeg$', $value) || Eregi('gif$', $value) || Eregi('png$', $value)){
        if ($value != "." && $value != ".." && Eregi('jpg$', $value) || Eregi('jpeg$', $value) || Eregi('gif$', $value) || Eregi('png$', $value)){
          $valueChk = $this->dirPath.$dirList_orgn[$i]."/".$value;
          list(,,$t,) = getimagesize($valueChk);
          if ($t < 4){
            $flg[$i] = true;
            break;
          }
        }
      }
      if($flg[$i]){
        array_push($dirList,$dirList_orgn[$i]);
      }
    }
    return $dirList;
  }

  //ディレクトリ内の画像ファイルを配列に格納
  private function check_file_image($dirList,$fileList_orgn) {
    $fileList = array();
    for($i=0; $i<count($fileList_orgn); $i++){
      $fileList[$i] = array();
      foreach($fileList_orgn[$i] as $value) {
        //if ($value != "." && $value != ".." && preg_match("/^[!-~]+$/", $value) && Eregi('jpg$', $value) || Eregi('jpeg$', $value) || Eregi('gif$', $value) || Eregi('png$', $value)){
        if ($value != "." && $value != ".." && Eregi('jpg$', $value) || Eregi('jpeg$', $value) || Eregi('gif$', $value) || Eregi('png$', $value)){
          $valueChk = $this->dirPath.$dirList[$i]."/".$value;
          list(,,$t,) = getimagesize($valueChk);
          if ($t < 4){
            array_push($fileList[$i],$value);
          }
        }
      }
    }
    return $fileList;
  }

  //ディレクトリCSV読込
  private function get_csv_dir() {
    $row    = 0;
    $csvDir = array();
    $handle = fopen($this->csvDirPath,"r");
    while(($tmp = reg_fgetcsv($handle)) !== FALSE){
      $csvDir[$row]["dir"]  = convert_enc($tmp[0]);
      $csvDir[$row]["name"] = convert_enc($tmp[1]);
      $csvDir[$row]["pub"]  = (isset($tmp[2]))? convert_enc($tmp[2]): 1;
      $row++;
    }
    fclose($handle);
    return $csvDir;
  }

  //ディレクトリCSV配列からディレクトリが存在しない行を除外
  private function marge_csv_dir($csvDir_orgn,$dirList) {
    $row = 0;
    $csvDir = array();
    for($i=0; $i < count($csvDir_orgn); $i++){
      for($j=0; $j < count($dirList); $j++){
        if($csvDir_orgn[$i]["dir"] == $dirList[$j]){
          $csvDir[$row]["dir"]  = $csvDir_orgn[$i]["dir"];
          $csvDir[$row]["name"] = $csvDir_orgn[$i]["name"];
          $csvDir[$row]["pub"]  = $csvDir_orgn[$i]["pub"];
          $row++;
        }
      }
    }
    return $csvDir;
  }

  //ファイルCSVを読込
  private function get_csv_files(){
    $row   = 0;
    $csvFiles = array();
    $handle = fopen($this->csvFilesPath,"r");
    while(($tmp = reg_fgetcsv($handle)) !== FALSE){
      $csvFiles[$row]["dir"]  = convert_enc($tmp[0]);
      $csvFiles[$row]["name"] = convert_enc($tmp[1]);
      $csvFiles[$row]["body"] = convert_enc($tmp[2]);
      $row++;
    }
    fclose($handle);
    return $csvFiles;
  }

} //END item_node



//ファイルパス取得
class item_config {
  var $path_dir = array();
  var $path_csv_dir  = array();
  var $path_csv_file = array();
  var $crrnt;

  // コンストラクタ
  function item_config($path_dir, $path_csv_dir, $path_csv_file, $crrnt="./") {
    $this->path_dir  = $path_dir;
    $this->path_csv_dir  = $path_csv_dir;
    $this->path_csv_file = $path_csv_file;
    $this->crrnt = $crrnt;
  }

  // メンバメソッド(public)
  public function get_path() {
    $this->dir_name  = $this->path_dir;
    $this->dir_path  = $this->crrnt.$this->path_dir."/";
    $this->csv_dir   = $this->crrnt.$this->path_csv_dir;
    $this->csv_files = $this->crrnt.$this->path_csv_file;
  }

} //END item_config
