<?php

function init($code = 'utf-8') {
  // 文字コード関連
  ini_set("output_buffering", "On");
  ini_set("output_handler", "mb_output_handler");
  ini_set("default_charset", $code);
  mb_language("Japanese");
  mb_internal_encoding ($code);
  mb_http_input("auto");
  mb_http_output($code);
  mb_detect_order("auto");
  mb_substitute_character("none");
  ob_start("mb_output_handler");

  // magic_quotes_gpc = On の場合の対策
  init_strip_magic_quotes();
}

// magic_quotes_gpc = On の場合の対策
// refered to:http://pentan.info/php/magic_quotes_on.html
function init_strip_magic_quotes(){
  if (get_magic_quotes_gpc()) {
    function strip_magic_quotes_slashes($arr){
      return is_array($arr) ?
      array_map('strip_magic_quotes_slashes', $arr) :
      stripslashes($arr);
    }
    $_GET     = strip_magic_quotes_slashes($_GET);
    $_POST    = strip_magic_quotes_slashes($_POST);
    $_REQUEST = strip_magic_quotes_slashes($_REQUEST);
    $_COOKIE  = strip_magic_quotes_slashes($_COOKIE);
  }
}

// HTTP_USER_AGENT取得
function get_user_agent($conf_agent) {
  $user  = "pc";
  $agent = $_SERVER['HTTP_USER_AGENT'];
  foreach($conf_agent as $key1 => $value1) {
    foreach($value1 as $key2 => $value2) {
      if(preg_match("/(".$value2.")/", $agent)) {
        $user = $key1;
        break 2;
      }
    }
  }
  return $user;
}

// HTTP_USER_AGENTを元に文字コードを指定
function get_user_code($user_agent) {
  $code = "UTF-8";
  switch($user_agent){
    case "mobile":
      $code = "Shift-JIS";
      break;
    case "smartphone":
      $code = "UTF-8";
      break;
    case "pc":
      $code = "UTF-8";
      break;
    default:
      $code = "UTF-8";
  }
  return $code;
}

// htmlspecialchars
function html_spc($str){
  if(is_array($str)){
    return array_map("h",$str);
  }else{
    $str = stripslashes($str); //バックスラッシュを排除
    $str = htmlspecialchars($str,ENT_QUOTES);
    return $str;
  }
  return false;
}

// 許可したhtmlタグだけエスケープせず出力
function html_escp($str,$tag = array()){
  if (count($tag) == 0 ) return $str;
  foreach($tag as $key => $item) {
    if (strpos($item, '/') === false) {
      $str = preg_replace_callback("/&lt;\/?". $item . "( .*?&gt;|\/?&gt;)/i","html_unescp", $str);
    }
  }
  return $str;
}

// タグを変換する
function html_unescp($str){
  $sStr = $str[0];
  $sStr = str_replace("&lt;", "<", $sStr);
  $sStr = str_replace("&gt;", ">", $sStr);
  $sStr = str_replace("&quot;", "\"", $sStr);
  return $sStr;
}

// エンコード
function convert_enc($str,$code="utf-8") {
  return mb_convert_encoding($str, $code, "auto");
}

//fgetcsv文字化け対策
//referred to: http://yossy.iimp.jp/wp/?p=56
function reg_fgetcsv (&$handle, $length = null, $d = ',', $e = '"') {
  $d = preg_quote($d);
  $e = preg_quote($e);
  $_line = "";
  while (($eof != true) and (!feof($handle))) {
  //while ($eof != true) {
    $_line .= (empty($length) ? fgets($handle) : fgets($handle, $length));
    $itemcnt = preg_match_all('/'.$e.'/', $_line, $dummy);
    if ($itemcnt % 2 == 0) $eof = true;
  }
  $_csv_line = preg_replace('/(?:\r\n|[\r\n])?$/', $d, trim($_line));
  $_csv_pattern = '/('.$e.'[^'.$e.']*(?:'.$e.$e.'[^'.$e.']*)*'.$e.'|[^'.$d.']*)'.$d.'/';
  preg_match_all($_csv_pattern, $_csv_line, $_csv_matches);
  $_csv_data = $_csv_matches[1];
  for($_csv_i=0;$_csv_i<count($_csv_data);$_csv_i++){
    $_csv_data[$_csv_i]=preg_replace('/^'.$e.'(.*)'.$e.'$/s','$1',$_csv_data[$_csv_i]);
    $_csv_data[$_csv_i]=str_replace($e.$e, $e, $_csv_data[$_csv_i]);
  }
  return empty($_line) ? false : $_csv_data;
}

//CSV読み込み
function get_data($filename){
  if(filesize($filename) > 0) {
    $row = 0;
    $handle = fopen($filename,"r");
    while (($tmp = reg_fgetcsv($handle)) !== false) {
      $data[$tmp[0]] = $tmp[1];
      $row++;
    }
    fclose($handle);
    return $data;
  }
  return false;
}

// user.csvの読み込みをチェック
function chk_data_user($filename){
  if(filesize($filename) > 0) {
    $handle = fopen($filename,"r");
    while (($tmp = reg_fgetcsv($handle)) !== false) {
      $data["user"] = $tmp[0];
      $data["pass"] = $tmp[1];
    }
    fclose($handle);
    if($data["user"] !== "" && $data["pass"] !== "") {
      return true;
    } else {
      return false;
    }
  }
  return false;
}

//プロフィール画像取得
function get_prof_image($path,$filename){
  $obj = "";
  $value = "";
  $arr = array(".gif",".GIF",".jpeg",".JPEG",".jpg",".JPG",".png",".PNG");
  for($i = 0; $i < count($arr); $i++){
    if(is_file($path.$filename.$arr[$i])){
      $value = $path.$filename.$arr[$i];
    }
  }
  if($value != null){
    list(,,$t,) = getimagesize($value);
    if ($t < 4){
      $obj = $value;
    }
  }
  return $obj;
}
