<?php


require_once("common.function.php");
require_once("common.config.php");
require_once("common.class.php");


init();


$config = get_data("../".PATH_CONF);

$path = new item_config(PATH_DIR_DIR,PATH_CSV_DIR,PATH_CSV_FILE,"../");
$path->get_path();

$node = new item_node($path->dir_name,$path->dir_path,$path->csv_dir,$path->csv_files,$config["allow_tag"],true);

$data  = array();
$thumb = array();
$error = false;


if(isset($_GET["dir"])){
  $data["dir"] = html_spc($_GET["dir"]);
} else {
  $error = true;
}

if(isset($_GET["file"]) && is_numeric($_GET["file"])){
  $data["file"] = html_spc($_GET["file"]);
} else {
  $error = true;
}

if(isset($_GET["size"]) && is_numeric($_GET["size"])){
  $data["size"] = html_spc($_GET["size"]);
} else {
  $error = true;
}

if(isset($_GET["node"]) && $_GET["node"] == "all"){
  $data["node"] = $node->dir;
} else {
  $data["node"] = $node->file;
}

$data["wtrim"] = (isset($_GET["wtrim"]) && $_GET["wtrim"] == 1)? true: false;
$data["htrim"] = (isset($_GET["htrim"]) && $_GET["htrim"] == 1)? true: false;

if(!$error){
  foreach($data["node"] as $key => $item){
    if($item["dir"] == $data["dir"]){
      $value = $item;
      break;
    }
  }
  $file = $data["file"];
  $code = $value["file"][$file]["code"];
  $type = $value["file"][$file]["type"];
  $name = $value["file"][$file]["name"];
  $ext  = $value["file"][$file]["ext"];
  $date = $value["file"][$file]["date"];
  $path = $value["path"].convert_enc($name,$code);
  if(!is_file($path)){
    $error = true;
  }
}

if(!$error){

  // 画像ファイルを読み込む
  switch($type){
    case 1:
      $imgHdType = "gif";
      $img = ImageCreateFromGIF($path);  // GIFファイルを読み込む
      break;
    case 2:
      $imgHdType = "jpeg";
      $img = ImageCreateFromJPEG($path); // JPEGファイルを読み込む
      break;
    case 3:
      $imgHdType = "png";
      $img = ImageCreateFromPNG($path);  // PNGファイルを読み込む
      break;
  }

  // 画像のサイズを取得
  $wOld = ImageSX($img); //横幅（ピクセル）
  $hOld = ImageSY($img); //縦幅（ピクセル）

  // 縮小した画像のサイズを決める
  if($wOld > $hOld){
    if(!$data["wtrim"]){
      $wDst = 0;
      $hDst = 0;
      if($wOld >= $data["size"]){
        $wNew = $data["size"];
      } else {
        $wNew = $wOld;
      }
      $h_cal = $hOld / $wOld;
      $hNew = floor($wNew * $h_cal);
    } else {
      $wDst  = floor(($wOld - $hOld)/2);
      $hDst  = 0;
      $wOld  = $wOld - ($wOld - $hOld);
      $w_cal = $wOld / $hOld;
      $hNew  = $data["size"];
      $wNew  = floor($hNew * $w_cal);
    }
  } else {
    if(!$data["htrim"]){
      $wDst = 0;
      $hDst = 0;
      if($hOld >= $data["size"]){
        $hNew  = $data["size"];
      } else {
        $hNew  = $hOld;
      }
      $w_cal = $wOld / $hOld;
      $wNew  = floor($hNew * $w_cal);
    } else {
      $hDst  = floor(($hOld - $wOld)/2);
      $wDst  = 0;
      $hOld  = $hOld - ($hOld - $wOld);
      $h_cal = $hOld / $wOld;
      $wNew  = $data["size"];
      $hNew  = floor($wNew * $h_cal);
    }
  }

  // 空の画像を作成
  $imgNew = ImageCreateTrueColor($wNew, $hNew);

  // GIF,PNGファイルの透過を保持する
  if ($type == 1 || $type == 3) {
    $tmp = array();
    $tmp["index"] = imagecolortransparent($img);
    if ($tmp["index"] >= 0) {
      $tmp["color"] = imagecolorsforindex($img, $tmp["index"]);
      $tmp["index"] = imagecolorallocate($imgNew, $tmp["color"]["red"], $tmp["color"]["green"], $tmp["color"]["blue"]);      imagefill($imgNew, 0, 0, $tmp["index"]);
      imagecolortransparent($imgNew, $tmp["index"]);
    } elseif ($type == 3) {
      imagealphablending($imgNew, false);
      $color = imagecolorallocatealpha($imgNew, 0, 0, 0, 127);
      imagefill($imgNew, 0, 0, $color);
      imagesavealpha($imgNew, true);
    }
  }

  // サンプリング
  ImageCopyResampled($imgNew,$img,0,0,$wDst,$hDst,$wNew,$hNew,$wOld,$hOld);

  // ブラウザに出力
  header("Content-type: image/{$imgHdType}");
  header("Cache-control: private");

  $thumb["temp"] = "../cache/thumb-".$data["dir"]."-".$data["file"]."-".$data["size"]."-".$data["wtrim"]."-".$data["htrim"].".".$ext;
  switch($type){
    case 1:
      ImageGIF($imgNew);
      ImageGIF($imgNew,  $thumb["temp"]);
      break;
    case 2:
      ImageJPEG($imgNew);
      ImageJPEG($imgNew, $thumb["temp"], 80); //第三引数は画質（0～100）
      break;
    case 3:
      ImagePNG($imgNew);
      ImagePNG($imgNew,  $thumb["temp"]);
      break;
  }

  // メモリを解放
  imageDestroy($imgNew);

  exit;
}

if($error){

}

?>