<?php

require_once("include/common.config.php");
require_once("include/common.class.php");
require_once("admin/include/admin.config.php");
require_once("admin/include/admin.function.php");
require_once("admin/include/admin.class.php");


init();
init_lifetime();
init_session();


//セッション取得：ログイン
$login = (isset($_SESSION["login"]))? $_SESSION["login"]: false;

if($login){
  header("Location: ./admin/index.php");
}

//アカウントをチェック
if(!chk_data_user(PATH_USER)){
  header("Location: ./install.php");
}

//セッション取得
$data = (isset($_SESSION["data"]))? $_SESSION["data"]: array();

//セッションリセット
unset($_SESSION["data"]);

//config.csvの値を取得
$config = get_data_conf(PATH_CONF);

//ステータス
$status = (isset($_GET["status"]))? html_spc($_GET["status"]): "";

//テンプレート読み込み
switch($status){
  case "forgot":
    include_once("admin/".$conf_html['login_forgot']);
    break;
  case "reissue":
    include_once("admin/".$conf_html['login_reissue']);
    break;
  default:
    include_once("admin/".$conf_html['login_regist']);
}

?>