<?php 

class theme_tmpl {
  var $config = array();
  var $theme;
  var $get;

  function theme_tmpl($value1, $value2, $get) {
    $this->config = $this->conf_enc($value1, "Shift-JIS");
    $this->theme  = $value2;
    $this->get    = $get;
    $this->theme_arg();
  }

  public function theme_arg() {
    $d = (isset($this->get["d"]))? $this->html_spc($this->get["d"]): "";
    $p = (isset($this->get["p"]))? $this->html_spc($this->get["p"]): 0;
    $f = (isset($this->get["f"]))? $this->html_spc($this->get["f"]): "";
    $prof = (isset($this->get["prof"]))? true: false;
    $this->dir  = $d;
    $this->page = $p;
    $this->file = $f;
    $this->prof = $prof;
  }

  public function path() {
    $html  = "";
    $html .= $this->config["path"];
    $this->path = $html;
    echo $this->path;
  }

  public function head() {
    $html  = "";
    $html .= "<title>".$this->config["site_name"]."</title>"."\n"."\n";
    if($this->config["site_description"] !== "") {
      $desc  = ereg_replace("\r|\n","",$this->config["site_description"]);
      $html .= '<meta name="description" content="'.$desc.'" />'."\n";
    }
    if($this->config["site_keyword"] !== "") {
      $html .= '<meta name="keywords" content="'.$this->config["site_keyword"].'" />'."\n";
    }
    if($this->config["site_robots"] == true) {
      $html .= '<meta name="robots" content="noindex,nofollow" />'."\n";
    }
    $this->head = $html;
    echo $this->head;
  }

  public function site_name() {
    $html  = "";
    $html .= $this->config["site_name"];
    $this->site_name = $html;
    echo $this->site_name;
  }

  public function site_description() {
    if($this->config["site_description"] !== "") {
      $html  = "";
      $html .= '<font size="2">'.nl2br($this->config["site_description"]).'</font><br />'."\n";
      $html .= '<br />'."\n";
      $this->site_description = $html;
      echo $this->site_description;
    }
  }

  public function top_thumb($dir) {
    $html  = "";
    for($i = 0; $i < $this->theme["item_col"]; $i++){
      $html .= '<td width="'.$this->theme["item_cell"].'" height="'.$this->theme["item_cell"].'" align="center">';
	    if($dir["file"][$i]["name"] != "") {
	      $html .= '<img src="./include/img-portfolio.thumb.php?dir='.$dir["dir"].'&amp;file='.$i.'&amp;size='.$this->theme["thumb_size"].'&amp;wtrim'.$this->theme["thumb_w"].'&amp;htrim='.$this->theme["thumb_h"].'" alt="'.$dir["file"][$i]["name"].'" vspace="5" />';
	    } else {
	      $html .= '&nbsp;';
      }
      $html .= '</td>'."\n";
    }
    $this->top_thumb = $html;
    echo $this->top_thumb;
  }

  public function thumb_arg() {
    $page  = $this->page;
    $min   = $this->theme["item_num"] * $page;
    $max   = $this->theme["item_num"] * ($page+1);
    $total = floor(count($this->config["data"][$this->dir]["file"]) / $this->theme["item_num"]);
    $prev  = ($page > 0)? $page - 1: "";
    $next  = ($page < $total)? $page + 1: "";
    $this->min   = $min;
    $this->max   = $max;
    $this->total = $total;
    $this->prev  = $prev;
    $this->next  = $next;
  }

  public function thumb_head() {
    $html  = "";
    $html .= '['.$this->config["data"][$this->dir]["name"].']<br />'."\n";
    $html .= '<br />'."\n";
    $html .= 'Page:'.($this->page+1).'/'.($this->total+1).'<br />'."\n";
    $html .= '<br />'."\n";
    $this->thumb_head = $html;
    echo $this->thumb_head;
  }

  public function thumb_list() {
    $html  = "";
    $html .= '<table width="'.$this->theme["item_tbl"].'" cellpadding="0" cellspacing="0" border="0" bgcolor="'.$this->theme["color_table"].'">'."\n";
    for($i = $this->min; $i < $this->max; $i++){
      $path = $this->config["data"][$this->dir]["file"][$i]["name"];
      if(($i+1) % $this->theme["item_col"] == 1 || $i == 0){
        $html .= '<tr valign="middle">'."\n";
      }
      if($path != ""){
        $html .= '<td width="'.$this->theme["item_cell"].'" height="'.$this->theme["item_cell"].'" align="center">'."\n";
        $html .= '<a href="./?d='.$this->dir.'&amp;f='.$i.'"><img src="./include/img-portfolio.thumb.php?dir='.$this->config["data"][$this->dir]["dir"] .'&amp;file='.$i.'&amp;size='.$this->theme["thumb_size"].'&amp;wtrim='.$this->theme["thumb_w"].'&amp;htrim='.$this->theme["thumb_h"].'" alt="'.$this->config["data"][$this->dir]["file"][$i]["name"].'" vspace="5" /></a><br />'."\n";
        $html .= '</td>'."\n";
      } else {
        $html .= '<td width="'.$this->theme["item_cell"].'" height="'.$this->theme["item_cell"].'">&nbsp;</td>'."\n";
      }
      if(($i+1) % $this->theme["item_col"] == 0){
        $html .= '</tr>'."\n";
      }
    }
    $html .= '</table>';
    $this->thumb_list = $html;
    echo $this->thumb_list;
  }

  public function thumb_prev() {
    $html  = "";
    if($this->prev !== ""){
      $html .= '<a href="./?d='.$this->dir.'&amp;p='.$this->prev.'">Prev</a>';
    } else {
      $html .= "Prev";
    }
    $this->thumb_prev = $html;
    echo $this->thumb_prev;
  }

  public function thumb_next() {
    $html  = "";
    if($this->next !== ""){
      $html .= '<a href="./?d='.$this->dir.'&amp;p='.$this->next.'">Next</a>';
    } else {
      $html .= "Next";
    }
    $this->thumb_next = $html;
    echo $this->thumb_next;
  }

  public function entry_arg() {
    $total = count($this->config["data"][$this->dir]["file"]) - 1;
    $prev  = ($this->file > 0)? $this->file - 1: "";
    $next  = ($this->file < $total)? $this->file + 1: "";
    $current = floor($this->file / $this->theme["item_num"]);
    $this->total = $total;
    $this->prev  = $prev;
    $this->next  = $next;
    $this->current = $current;
  }

  public function entry_head() {
    $html  = "";
    $html .= '['.$this->config["data"][$this->dir]["name"].']<br />'."\n";
    $html .= '<br />'."\n";
    $html .= ($this->file+1).'/'.($this->total+1).'<br />'."\n";
    $html .= '<br />'."\n";
    $this->entry_head = $html;
    echo $this->entry_head;
  }

  public function entry_image() {
    $html  = "";
    $html .= '<img src="./include/img-portfolio.thumb.php?dir='.$this->config["data"][$this->dir]["dir"].'&amp;file='.$this->file.'&amp;size='.$this->theme["item_size"].'&amp;wtrim=0&amp;htrim=0" alt="'.$this->config["data"][$this->dir]["file"][$this->file]["name"].'" /><br />'."\n";
    $html .= '<br />'."\n";
    $this->entry_image = $html;
    echo $this->entry_image;
  }

  public function entry_name() {
    $html  = "";
    if($this->config["data"][$this->dir]["file"][$this->file]["name"] !== ""){
      $html .= $this->config["data"][$this->dir]["file"][$this->file]["name"] .'<br />'."\n";
      $html .= '<br />'."\n";
    }
    $this->entry_name = $html;
    echo $this->entry_name;
  }

  public function entry_caption() {
    $html  = "";
    if($this->config["data"][$this->dir]["file"][$this->file]["body"] !== ""){
      $html .= $this->config["data"][$this->dir]["file"][$this->file]["body"] .'<br />'."\n";
      $html .= '<br />'."\n";
    }
    $this->entry_caption = $html;
    echo $this->entry_caption;
  }

  public function entry_prev() {
    $html  = "";
    if($this->prev !== ""){
      $html .= '<a href="./?d='.$this->dir.'&amp;f='.$this->prev.'">Prev</a>';
    } else {
      $html .= "Prev";
    }
    $this->entry_prev = $html;
    echo $this->entry_prev;
  }

  public function entry_next() {
    $html  = "";
    if($this->next !== ""){
      $html .= '<a href="./?d='.$this->dir.'&amp;f='.$this->next.'">Next</a>';
    } else {
      $html .= "Next";
    }
    $this->entry_next = $html;
    echo $this->entry_next;
  }

  public function entry_back() {
    $html  = "";
    $html .= '<a href="./?d='.$this->dir.'&amp;p='.$this->current.'">['.$this->config["data"][$this->dir]["name"].']ؽĂɖ߂</a><br />'."\n";
    $this->entry_back = $html;
    echo $this->entry_back;
  }

  public function prof_btn() {
    if($this->config["prof_disp"] !== "" && $this->config["prof_disp"] == 1) {
      $html  = "";
      $html .= '<a href="./?prof">̨</a>'."\n";
      $this->prof_btn = $html;
      echo $this->prof_btn;
    }
  }

  public function prof_disp() {
    $flg  = ($this->config["prof_disp"] !== "" && $this->config["prof_disp"] == 1)? true: false;
    $this->prof_disp = $flg;
    return $this->prof_disp;
  }

  public function prof_name() {
    if($this->config["prof_name"] !== "") {
      $html  = "";
      $html .= '<p><font size="3">'.$this->config["prof_name"].'</font></p>'."\n";
      $html .= '<br />'."\n";
      $this->prof_name = $html;
      echo $this->prof_name;
    }
  }

  public function prof_mail() {
    if($this->config["mail_name"] !== "" && $this->config["mail_disp"] == 1) {
      $html  = "";
      $html .= 'Mail<br />'."\n";
      $html .= '<a href="mailto:' .$this->config["mail_name"].'">'.$this->config["mail_name"].'</a><br />'."\n";
      $html .= '<br />'."\n";
      $this->prof_mail = $html;
      echo $this->prof_mail;
    }
  }

  public function prof_description() {
    if($this->config["prof_description"] !== "") {
      $html  = "";
      $html .= nl2br($this->config["prof_description"]).'<br />'."\n";
      $html .= '<br />'."\n";
      $this->prof_description = $html;
      echo $this->prof_description;
    }
  }

  public function prof_image() {
    if($this->config["prof_image"] !== "") {
      $html  = "";
      $html .= '<img src="'.$this->config["prof_image"].'" alt="profile image" width="150" /><br />'."\n";
      $html .= '<br />'."\n";
      $this->prof_image = $html;
      echo $this->prof_image;
    }
  }

  public function lnk_twttr() {
    if($this->config["lnk_twttr"] !== "") {
      $html  = "";
      $html .= '<a href="http://twitter.com/' .$this->config["lnk_twttr"].'">Twitter</a><br />'."\n";
      $html .= '<br />'."\n";
      $this->lnk_twttr = $html;
      echo $this->lnk_twttr;
    }
  }

  public function lnk_facebook() {
    if($this->config["lnk_facebook"] !== "") {
      $html  = "";
      $html .= '<a href="http://www.facebook.com/' .$this->config["lnk_facebook"].'">facebook</a><br />'."\n";
      $html .= '<br />'."\n";
      $this->lnk_twttr = $html;
      echo $this->lnk_twttr;
    }
  }

  public function lnk_mixi() {
    if($this->config["lnk_mixi"] !== "") {
      $html  = "";
      $html .= '<a href="http://mixi.jp/show_friend.pl?id=' .$this->config["lnk_mixi"].'">Mixi</a><br />'."\n";
      $html .= '<br />'."\n";
      $this->lnk_mixi = $html;
      echo $this->lnk_mixi;
    }
  }

  public function lnk_blog() {
    if($this->config["lnk_blog"] !== "") {
      $html  = "";
      $html .= '<a href="'.$this->config["lnk_blog"].'">Blog</a><br />'."\n";
      $html .= '<br />'."\n";
      $this->lnk_blog = $html;
      echo $this->lnk_blog;
    }
  }

  public function copy() {
    if($this->config["site_copy"] !== "") {
      $html  = "";
      $html .= $this->config["site_copy"];
      $this->copy = $html;
      echo $this->copy;
    }
  }

  private function conf_enc($value ,$code="utf-8") {
    $res = array();
    foreach($value as $key => $item) {
      if(is_array($item)) {
        $res[$key] = $this->conf_enc($item, "Shift-JIS");
      } else {
        $res[$key] = mb_convert_encoding($item, $code, "auto");
      }
    }
    return $res;
  }

  private function html_spc($str){
    if(is_array($str)){
      return array_map("h",$str);
    }else{
      $str = stripslashes($str); //obNXbVr
      $str = htmlspecialchars($str,ENT_QUOTES);
      return $str;
    }
    return false;
  }

}

?>