<?php 

class theme_tmpl {
  var $config = array();
  var $theme  = array();

  function theme_tmpl($value1, $value2) {
    $this->config = $value1;
    $this->theme  = $value2;
  }

  public function path() {
    $html  = "";
    $html .= $this->config["path"];
    $this->path = $html;
    echo $this->path;
  }

  public function head() {
    $html  = "";
    $html .= "<title>".$this->config["site_name"]."</title>"."\n"."\n";
    if($this->config["site_description"] !== "") {
      $desc  = ereg_replace("\r|\n","",$this->config["site_description"]);
      $html .= '<meta name="description" content="'.$desc.'" />'."\n";
    }
    if($this->config["site_keyword"] !== "") {
      $html .= '<meta name="keywords" content="'.$this->config["site_keyword"].'" />'."\n";
    }
    if($this->config["site_robots"] == true) {
      $html .= '<meta name="robots" content="noindex,nofollow" />'."\n";
    }
    $this->head = $html;
    echo $this->head;
  }

  public function site_name() {
    $html  = "";
    $html .= $this->config["site_name"];
    $this->site_name = $html;
    echo $this->site_name;
  }

  public function menu() {
    $html  = "";
    $html .= "    <ul>"."\n";
    foreach ($this->config["data"] as $key => $dir){
      $html .= '      <li>' .'<a href="#'.$dir["dir"].'" class="'.$dir["dir"].'">'.$dir["name"].'</a></li>'."\n";
    }
    $html .= "    </ul>"."\n";
    $this->menu = $html;
    echo $this->menu;
  }

  public function thumb() {
    $html  = "";
    foreach ($this->config["data"] as $d => $dir) {
      $html  .= '  <div class="thumb-dir">'."\n";
      $html  .= '    <h2 id="'.$dir["dir"].'">'.$dir["name"].'</h2>'."\n";
      $html  .= '    <div class="thumb-list">'."\n";
      foreach ($dir["file"] as $f => $file) {
        if ($f == 0){
          $html  .= '      <ul class="clearfix">'."\n";
        } else if($f % $this->theme["thumb_page"] == 0){
          $html  .= '      </ul>'."\n";
          $html  .= '      <ul class="clearfix">'."\n";
        }
        $html    .= '        <li>'."\n";
        $html    .= '          <dl>'."\n";
        $html    .= '            <dt><a href="'.$file["path"].'" class="'.$dir["dir"].'/'.$f.'  thumb-img">'.$dir["dir"].'-'.$file["name"].'</a></dt>'."\n";
        if($file["body"] != "") {
          $html    .= '            <dd>'.$file["body"].'</dd>'."\n";
        } else {
          $html    .= '            <dd>&nbsp;</dd>'."\n";
        }
        $html    .= '          </dl>'."\n";
        $html    .= '        </li>'."\n";
        if ($f == count($dir["file"]) - 1) {
          $html  .= '      </ul>'."\n";
        }
      }
      $html  .= '    </div>'."\n";
      $html  .= '    <div class="thumb-pager">'."\n";
      $num = floor(count($dir["file"]) / $this->theme["thumb_page"]);
      $num = (count($dir["file"]) % $this->theme["thumb_page"] == 0)? $num: $num + 1;
      if ($num > 1) {
        $html  .= '      <ul class="clearfix">'."\n";
        for ($i = 0; $i < $num; $i++) {
          $html  .= '        <li>'.($i+1).'</li>'."\n";
        }
        $html  .= '      </ul>'."\n";
      } else {
        $html  .= '      &nbsp;'."\n";
      }
      $html  .= '    </div>'."\n";
      $html  .= '  </div>'."\n";
    }
    $this->thumb = $html;
    echo $this->thumb;
  }

  public function prof_btn() {
    if($this->config["prof_disp"] !== "" && $this->config["prof_disp"] == 1) {
      $html  = "";
      $html .= '<p id="prof-btn"><img src="'.$this->config["path"].'common/button-profile.gif" alt="profile" width="60" height="30" /></p>'."\n";
      $this->prof_btn = $html;
      echo $this->prof_btn;
    }
  }

  public function prof_disp() {
    $flg  = ($this->config["prof_disp"] !== "" && $this->config["prof_disp"] == 1)? true: false;
    $this->prof_disp = $flg;
    return $this->prof_disp;
  }

  public function prof_txt() {
    $html  = "";
    if($this->config["prof_name"] !== "") {
      $html .= '      <dt>'.$this->config["prof_name"].'</dt>'."\n";
    }
    if($this->config["mail_name"] !== "" && $this->config["mail_disp"] == 1) {
      $html .= '      <dd class="mail">'.'<a href="mailto:' .$this->config["mail_name"].'">'.$this->config["mail_name"].'</a>'.'</dd>'."\n";
    }
    if($this->config["prof_description"] !== "") {
      $html .= '      <dd class="description">'.nl2br($this->config["prof_description"]).'</dd>'."\n";
    }
    if($html !== "") {
      $html  = '    <dl class="txt">'."\n".$html.'    </dl>'."\n";
      $this->prof_txt = $html;
      echo $this->prof_txt;
    }
  }

  public function prof_image() {
    if($this->config["prof_image"] !== "") {
      $html  = "";
      $html .= '      <p class="photo">'.'<img src="'.$this->config["prof_image"].'" alt="profile image" width="150" height="150" />'.'</p>'."\n";
      $this->prof_image = $html;
      echo $this->prof_image;
    }
  }

  public function prof_lnk() {
    $html  = "";
    if($this->config["lnk_twttr"] !== "") {
      $html .= '      <li><a href="http://twitter.com/' .$this->config["lnk_twttr"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-twitter.png" width="24" height="24" alt="" /></a></li>'."\n";
    }
    if($this->config["lnk_facebook"] !== "") {
      $html .= '      <li><a href="http://www.facebook.com/' .$this->config["lnk_facebook"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-facebook.png" width="24" height="24" alt="" /></a></li>'."\n";
    }
    if($this->config["lnk_mixi"] !== "") {
      $html .= '      <li><a href="http://mixi.jp/show_friend.pl?id=' .$this->config["lnk_mixi"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-mixi.png" width="24" height="24" alt="" /></a></li>'."\n";
    }
    if($this->config["lnk_blog"] !== "") {
      $html .= '      <li><a href="'.$this->config["lnk_blog"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-blog.png" width="24" height="24" alt="" /></a></li>'."\n";
    }
    if($html !== "") {
      $html  = '      <ul>'."\n".$html.'      </ul>'."\n";
      $this->prof_lnk = $html;
      echo $this->prof_lnk;
    }
  }

  public function copy() {
    if($this->config["site_copy"] !== "") {
      $html  = "";
      $html .= '  <address>'.$this->config["site_copy"].'</address>'."\n";
      $this->copy = $html;
      echo $this->copy;
    }
  }

}

?>