/* -----------------------------------------------------------------------------
Img-Portfolio PC Theme : Lightbox : jQuery Plugin

Update    : 2011.08.15
Copyright : TANAKA Hirohito by CVP
Url       : http://cvp-web.net/
E-Mail　　: imgp@cvp-web.net
Lisence   : MIT license
----------------------------------------------------------------------------- */



(function() {

$().ready(function(){
  $().imgPortfolio();
});

// imgPortfolio Plugin START
$.fn.imgPortfolio = function() {

  var eventComponent = function() {
    this.self = this;
    this.xml;
    this.num  = {total: "", menu: 0, thumb: 0};
    this.menu = {dir:   "", name: ""};
    this.img  = {name:  "", caption: "", width: "", height: "", top: "", left: ""};
    this.win  = {width: "", height:  "", top:   "", left:   ""};
    this.timerID;
    this.setup();
  }

  eventComponent.prototype = {

    // 初期設定
    setup : function(){
      var self = this;
      self.setupMenu();
      self.setupThumb();
      self.setupMain();
      self.setupProf();
      self.xmlLoading();
    },

    // 初期設定：メニュー
    setupMenu : function(){
      var self = this;
      $(cfg.id_menu).find("a")
        .bind("mouseover",self.cursorMOver)
        .bind("mouseout",self.cursorMOut)
        .each(function(i){
          self.clickHandler($(this),"click",self.clickDefault);

          var hash = $(this).attr("href");
          $(this).attr("href",hash+"/list");
          /*
          var hash = $(this).attr("href");
          var menuStr,menuItem;
          menuStr   = hash.indexOf("-", 1);
          menuItem  = (menuStr > 0)? hash.substring(menuStr+1): "";
          $(this).attr("href","#"+menuItem);
          */
        });
    },

    // 初期設定：サムネイル
    setupThumb : function(){
      var self = this;
      if(!cfg.thumb_name){
        $(cfg.id_thumb).find("h2").css({"display":"none"});
      }
      $(cfg.id_thumb).find(".thumb-pager > ul > li").bind("mouseover",self.cursorMOver).bind("mouseout",self.cursorMOut);
      $(cfg.id_thumb).find(".thumb-dir > .thumb-list > ul > li").find(".thumb-img")
        .css({"display":"block","width":cfg.thumb_size+"px","height":cfg.thumb_size+"px"})
        .bind("mouseover",self.opctyMOver)
        .bind("mouseout",self.opctyMOut);
    },

    // 初期設定：メイン
    setupMain : function(){
      var self = this;
      self.setupLoader(".main-loader");
    },

    // 初期設定：プリローダー
    setupLoader : function(value) {
      var mw,mh,vw,vh,ml,mt;
      mw  = $(cfg.id_loader).width();
      mh  = $(cfg.id_loader).height();
      vw  = $(cfg.id_loader).find(value).width();
      vh  = $(cfg.id_loader).find(value).height();
      ml = Math.floor((mw - vw)/2);
      mt = Math.floor((mh - vh)/2);
      $(cfg.id_loader).find(value).css({"marginLeft":ml+"px","marginTop":mt+"px"});
    },

    // 初期設定：プロフィール
    setupProf : function(){
      var self = this;
      $("body").append("<div id=\""+ cfg.id_over.replace(/^#/, "") +"\"></div>");
      $(cfg.id_over).css({
        background: cfg.over_clr,
        zIndex    : 10,
        position  : "fixed",
        opacity   : cfg.over_opc,
        left      : 0,
        top       : 0,
        display   : "none"
      });
      $(cfg.id_prof).css({
        width     : cfg.prof_w+"px",
        height    : cfg.prof_h+"px",
        background: cfg.prof_clr,
        zIndex    : 100,
        position  : "fixed",
        opacity   : 1.0,
        display   : "none"
      });
      $(cfg.id_prof).find(".close > img")
        .css({opacity: cfg.thumb_over})
        .bind("mouseover",self.cursorMOver)
        .bind("mouseover",self.opctyMOut)
        .bind("mouseout", self.cursorMOut)
        .bind("mouseout", self.opctyMOver);
      $(cfg.id_prof).find(".link > ul > li > a > img")
        .bind("mouseover",self.opctyMOver)
        .bind("mouseout", self.opctyMOut);
      self.profileDisplay();
    },

    // XML取得
    xmlLoading : function(){
      var self = this;
      $.ajax({
        type: "GET",
        url:"./include/img-portfolio.xml.php",
        cache: false,
        dataType: "xml",
        timeout: 10000,
        error:function() {
          return true;
        },
        success:function(data) {
          self.xml = data;
          this.obj1 = self.menuLoading();
          return this;
        }
      });
    },

    // メニュー：ローディング
    menuLoading : function(){
      var self = this;
      var hash = window.location.hash;
      var menuStr,menuItem,thumbStr,thumbItem;
      menuStr   = hash.indexOf("/", 1);
      menuItem  = (menuStr > 0)? hash.substring(1, menuStr): hash.substring(1);
      thumbStr  = hash.indexOf("/", 1);
      thumbItem = (thumbStr > 0)? hash.substring(thumbStr+1): "";
      if(menuItem != ""){
        $("directory",self.xml).each(function(i){
          var dir = $(this).find("dir").text();
          if(dir == menuItem){
            self.num.menu = i;
            $(cfg.id_menu).find("li").eq(self.num.menu).addClass("selected");
          }
        });
      } else {
        $(cfg.id_menu).find("li").eq(self.num.menu).addClass("selected");
      }
      if(thumbItem != ""){
        $("directory",self.xml).each(function(i){
          $(this).find("item").each(function(j){
            var name = $(this).find("name").text();
            if(name == thumbItem){
              self.num.thumb = j;
            }
          });
        });
      }
      var menuList = $(cfg.id_menu).find("a");
      menuList.unbind("click");
      $(cfg.id_loader).fadeIn(cfg.img_fade, function() {
        self.thumbLoading();
      });
    },

    // メニュー：クリックイベント
    menuClick : function(){
      var self = this;
      var thumbDir = $(cfg.id_thumb).find(".thumb-dir").eq(self.num.menu);
      var menuList = $(cfg.id_menu).find("a");
      menuList.each(function(i){
        $(this).bind("click",function(){
          $(cfg.id_loader).find(".main-loader > p").eq(0).find("img").width(0);
          $(cfg.id_loader).find(".main-loader > p").eq(1).html("Now Loading...");
          menuList.unbind("click");
          menuList.parent("li").removeClass("selected");
          $(this).parent("li").addClass("selected");
          thumbDir.find(".thumb-pager > ul > li").unbind("click");
          $(cfg.id_thumb).find(".thumb-dir").eq(self.num.menu).fadeOut(cfg.img_fade,function(){
            $(cfg.id_loader).fadeIn(cfg.img_fade);
            thumbDir.find(".thumb-list > ul").removeClass("selected");
            thumbDir.find(".thumb-pager > ul > li").removeClass("selected");
            thumbDir.find(".thumb-list  > ul > li").find(".thumb-img").eq(self.num.thumb).bind("mouseover",self.opctyMOver).bind("mouseout",self.opctyMOut);
            self.num.menu  = i;
            self.num.thumb = 0;
            self.thumbLoading();
          });
        });
      });
    },

    // サムネイル：ローディング
    thumbLoading : function(){
      var self = this;
      self.num.total  = $(".thumb-list").eq(self.num.menu).find(".thumb-img").length;
      var num  = 0;
      var node = $("directory",self.xml).eq(self.num.menu);
      self.menu.dir  = node.children("dir").text();
      self.menu.name = node.children("name").text();
      $(".thumb-list").eq(self.num.menu).find(".thumb-img").each(function(i){
        var dir    = node.children("dir").text();
        var name   = node.children("files").find("item").eq(i).children("name").text();
        var width  = node.children("files").find("item").eq(i).children("width").text();
        var height = node.children("files").find("item").eq(i).children("height").text();
        self.getSizeImage(width,height,cfg.thumb_size,cfg.thumb_size);
        var mt,ml;
        if(cfg.thumb_h == 1 && cfg.thumb_w == 1) {
          mt = 0;
          ml = 0;
        } else if(cfg.thumb_h == 1 && cfg.thumb_w == 0) {
          mt = self.img.top;
          ml = 0;
        } else if(cfg.thumb_h == 0 && cfg.thumb_w == 1) {
          mt = 0;
          ml = self.img.left;
        } else {
          mt = self.img.top;
          ml = self.img.left;
        }
        $(this).html("<img src=\"include/img-portfolio.thumb.php?dir="+self.menu.dir+"&amp;file="+i+"&amp;size="+cfg.thumb_size+"&amp;wtrim="+cfg.thumb_w+"&amp;htrim="+cfg.thumb_h+"\" alt=\""+dir+"\" class=\"thumb-image file"+self.num.menu+"-"+i+"\" style=\"margin-top:"+mt+"px;margin-left:"+ml+"px;\" />");
        $(this).find("img").unbind("load");
        $(this).find("img").bind("load", function() {
          num++;
          var per = Math.floor((num/self.num.total)*100);
          $(cfg.id_loader).find(".main-loader > p").eq(0).find("img").width(per);
          $(cfg.id_loader).find(".main-loader > p").eq(1).html("Now Loading...<br />"+num +"/"+ self.num.total);
          if(num == (self.num.total)){
            setTimeout( function() {
              $(cfg.id_loader).fadeOut(cfg.img_fade, function() {
                self.thumbFadeIn();
              });
            }, 500);
          }
        });
      });
    },

    // サムネイル：フェードイン
    thumbFadeIn : function(){
      var self = this;
      var menuList = $(cfg.id_menu).find("a");
      var thumbDir = $(cfg.id_thumb).find(".thumb-dir").eq(self.num.menu);
      var cal = Math.floor(self.num.thumb/cfg.thumb_page);
      self.pagerSwitch(self.num.thumb);
      thumbDir.find(".thumb-pager > ul > li").eq(cal).addClass("selected");
      thumbDir.fadeIn("normal",function(){
        self.menuClick();
        self.pagerClick();
        menuList.eq(self.num.menu).unbind("click");
      });
    },

    // サムネイル：クリックイベント
    thumbClick : function(){
      var self = this;
      var thumbDir = $(cfg.id_thumb).find(".thumb-dir").eq(self.num.menu);
      thumbDir.find(".thumb-list > ul > li").each(function(i){
        $(this).bind("click",function(){
          if(i != self.num.thumb){
            thumbDir.find(".thumb-list > ul > li").unbind("click");
          }
        });
      });
    },

    // ページャ：ページ切替判定
    pagerSwitch : function(num){
      var self = this;
      var i = Math.floor(num/cfg.thumb_page);
      var thumbDir = $(cfg.id_thumb).find(".thumb-dir").eq(self.num.menu);
      thumbDir.find(".thumb-list > ul").removeClass("selected");
      thumbDir.find(".thumb-list > ul").eq(i).addClass("selected");
      thumbDir.find(".thumb-pager > ul > li").removeClass("selected");
      thumbDir.find(".thumb-pager > ul > li").eq(i).addClass("selected");
    },

    // ページャ：クリック処理
    pagerClick : function(){
      var self = this;
      var thumbDir = $(cfg.id_thumb).find(".thumb-dir").eq(self.num.menu);
      thumbDir.find(".thumb-pager > ul > li").each(function(i){
        $(this).bind("click",function(){
          thumbDir.find(".thumb-list > ul").removeClass("selected");
          thumbDir.find(".thumb-list > ul").eq(i).addClass("selected");
          thumbDir.find(".thumb-pager > ul > li").removeClass("selected");
          thumbDir.find(".thumb-pager > ul > li").eq(i).addClass("selected");
        });
      });
    },

    // プロフィール：表示
    profileDisplay : function(){
      var self = this;
      $(cfg.id_profbtn).bind("mouseover",self.cursorMOver);
      $(cfg.id_profbtn).bind("mouseout",self.cursorMOut);
      if (typeof document.body.style.maxHeight == "undefined") {
        $(window).scroll(function(){
          self.getWindowSize();
        });
      }
      $(cfg.id_profbtn).bind("click",function(){
        self.getWindowSize();
        $("select").hide();
        if (typeof document.body.style.maxHeight == "undefined") {
          $("body").css({height:"100%",width:"100%"});
          $("html").css("overflow","hidden");
        }
        $(cfg.id_over).unbind("click");
        $(cfg.id_over).fadeIn(function(){
          if(jQuery.browser.msie) {
            $(cfg.id_prof).fadeIn(function(){
              this.style.removeAttribute('filter');
              $(cfg.id_prof).find(".close > img").bind("click", self.profileHide);
              $(cfg.id_over).bind("click", self.profileHide);
            });
          } else {
            $(cfg.id_prof).fadeIn(function(){
              $(cfg.id_prof).find(".close > img").bind("click", self.profileHide);
              $(cfg.id_over).bind("click", self.profileHide);
            });
          }
        });
      });
    },

    // プロフィール：非表示
    profileHide : function(){
      var self = this;
      $(cfg.id_prof).fadeOut(function(){
        $(cfg.id_over).fadeOut(function(){
          $("select").show();
          if (typeof document.body.style.maxHeight == "undefined") {
            $("body").css({height:"auto",width:"auto"});
            $("html").css("overflow","");
          }
          $(cfg.id_over).hide();
          $(cfg.id_prof).hide();
        });
      });
    },

    // リンクを無効化する
    preventDefault : function(e){
      if(e.preventDefault){
        e.preventDefault();
      }
      else if(window.event){
        window.event.returnValue = false;
      }
    },

    clickHandler : function(node,evt,func){
      if(node.addEventListener){
        node.addEventListener(evt,func,false);
      } else if(node.attachEvent){
        node.attachEvent("on"+evt,func);
      }
    },

    clickDefault : function(e){
      self.preventDefault(e);　//この関数でリンクを無効化する
    },

    // マウスオーバー処理・透過
    opctyMOver : function(){
      $(this).stop().animate({opacity: cfg.thumb_over}, cfg.thumb_fade);
    },

    // マウスアウト処理・透過
    opctyMOut : function(){
      $(this).stop().animate({opacity: cfg.thumb_out}, cfg.thumb_fade);
    },

    // マウスオーバー処理・ポインター
    cursorMOver : function (){
      $(this).css("cursor","pointer");
    },

    // マウスアウト処理・ポインター
    cursorMOut : function (){
      $(this).css("cursor","default");
    },

    // 表示する画像のサイズを計算
    getSizeImage : function(w,h,wNew,hNew) {
      var self = this;
      var flg;
      var calWidth;
      var calHeight;
      if(w > h){
        flg = (w >= wNew)? wNew: w;
        self.img.width   = flg;
        calHeight = h / w;
        self.img.height = Math.floor(self.img.width * calHeight);
        self.img.top    = Math.floor((hNew - self.img.height)/2);
        self.img.left   = Math.floor((wNew - self.img.width)/2);
        if(self.img.height > hNew){
          self.img.height = hNew;
          calWidth  = w / h;
          self.img.width  = Math.floor(self.img.height * calWidth);
          self.img.top    = Math.floor((hNew - self.img.height)/2);
          self.img.left   = Math.floor((wNew - self.img.width)/2);
        }
      } else {
        flg = (h >= hNew)? hNew: h;
        self.img.height  = flg;
        calWidth  = w / h;
        self.img.width  = Math.floor(self.img.height * calWidth);
        self.img.top    = Math.floor((hNew - self.img.height)/2);
        self.img.left   = Math.floor((wNew  - self.img.width)/2);
        if(self.img.width > wNew){
          self.img.width  = wNew;
          calHeight = h / w;
          self.img.height = Math.floor(self.img.width * calHeight);
          self.img.top    = Math.floor((hNew - self.img.height)/2);
          self.img.left   = Math.floor((wNew  - self.img.width)/2);
        }
      }
    },

    // ブラウザのウィンドウ・サイズ取得
    getWindowSize : function(){
      var self = this;
      self.win.width  = window.innerWidth || self.innerWidth || (document.documentElement&&document.documentElement.clientWidth) || document.body.clientWidth;
      self.win.height = window.innerHeight || self.innerHeight || (document.documentElement&&document.documentElement.clientHeight) || document.body.clientHeight;
      if (typeof document.body.style.maxHeight == "undefined") {
        self.win.height = $("body:first").height();
      }
      self.win.left = Math.floor(($(window).width() - $(cfg.id_prof).width()) / 2);
      self.win.top  = Math.floor(($(window).height() - $(cfg.id_prof).height()) / 2);
      $(cfg.id_over).css({width:self.win.width,height:self.win.height});
      $(cfg.id_prof).css({top:self.win.top,left:self.win.left});
      if (typeof document.body.style.maxHeight == "undefined") {
        $(cfg.id_prof).css({top:$(document).scrollTop()+self.win.top});
      }
    }
  }

  return new eventComponent(cfg);

}

})(jQuery);