/* -----------------------------------------------------------------------------
Img-Portfolio Smartphone Theme : Black : jQuery Plugin

Update    : 2011.08.15
Copyright : TANAKA Hirohito by CVP
Url       : http://cvp-web.net/
E-Mail　　: imgp@cvp-web.net
Lisence   : MIT license
----------------------------------------------------------------------------- */



(function() {

$().ready(function(){
  $().imgPortfolio();
});

// imgPortfolio Plugin START
$.fn.imgPortfolio = function() {

  var eventComponent = function() {
    this.self = this;
    this.xml;
    this.num  = {total: "", menu: null, thumb: null};
    this.img  = {name:  "", caption: "", width: "", height: "", top: "", left: ""};
    this.menu = {dir:   "", name: ""};
    this.setup();
  }

  eventComponent.prototype = {

    // 初期設定
    setup : function(){
      var self = this;
      self.xmlLoading();
    },

    // 画面リサイズ時の挙動
    winResize : function(){
      var self = this;
      $(window).resize(function(){
      });
    },

    // XML取得
    xmlLoading : function(){
      var self = this;
      var hash = window.location.hash;
      var path = (hash != "" && hash != "#top")? "../": "./";
      $.ajax({
        type: "GET",
        url: path+"include/img-portfolio.xml.php",
        cache: false,
        dataType: "xml",
        timeout: 10000,
        error:function() {
          return true;
        },
        success:function(data) {
          self.xml = data;
          self.menuClick();
          self.preLoading();
          return this;
        }
      });
    },

    // プリローディング
    preLoading : function(){
      var self = this;
      var hash = window.location.hash;
      var menuStr,menuItem,thumbStr,thumbItem;
      menuStr   = hash.indexOf("/", 1);
      menuItem  = (menuStr > 0)? hash.substring(1, menuStr): hash.substring(1);
      thumbStr  = hash.indexOf("/", 1);
      thumbItem = (thumbStr > 0)? hash.substring(thumbStr+1): "";
      if(menuItem != "" && menuItem != "#top" && thumbItem == "list"){
        $("directory",self.xml).each(function(i){
          var dir = $(this).find("dir").text();
          if(dir == menuItem){
            self.menuSwitch(i);
          }
        });
      } else if(menuItem != "" && menuItem != "#top" && thumbItem != "list"){
        $("directory",self.xml).each(function(i){
          var dir = $(this).find("dir").text();
          $(this).find("item").each(function(j){
            var name = $(this).find("name").text();
            if(dir == menuItem && name == thumbItem){
              self.menuSwitch(i);
              self.imgLoading(i,j);
              self.pagerClick();
            }
          });
        });
      }
    },

    // メニュー：クリックイベント
    menuClick : function(){
      var self = this;
      $(".menu-list").each(function(i){
        $(this).click(function(){
          setTimeout( function() {
            self.menuSwitch(i);
          }, 750);
        });
      });
    },

    // メニュー：クリックイベント
    menuSwitch : function(i){
      var self = this;
      var flg  = $(".thumb-list").eq(i).hasClass("loaded");
      self.num.menu = i;
      self.num.thumb = null;
      if(!flg){
        $(".thumb-loading").eq(i).css({display: "block"});
        $(".thumb-list").eq(i).css({display: "none"}).html("");
        $(".loading-bar").eq(i).find("img").width(0);
        $(".loading-txt").eq(i).html("Now Loading");
        self.thumbLoading();
      }
    },

    // サムネイル：ローディング
    thumbLoading : function(){
      var self = this;
      var node = $("directory",self.xml).eq(self.num.menu);
      var num  = 0;
      self.menu.dir  = node.children("dir").text();
      self.num.total = node.children("files").find("item").length;
      node.find("item").each(function(i){
        var name   = $(this).find("name").text();
        var width  = $(this).find("width").text();
        var height = $(this).find("height").text();
        var anchor = "#"+self.menu.dir+"/"+name;
        self.getSizeImage(width,height,cfg.thumb_size,cfg.thumb_size);
        var mt,ml;
        if(cfg.thumb_h == 1 && cfg.thumb_w == 1) {
          mt = 0;
          ml = 0;
        } else if(cfg.thumb_h == 1 && cfg.thumb_w == 0) {
          mt = self.img.top;
          ml = 0;
        } else if(cfg.thumb_h == 0 && cfg.thumb_w == 1) {
          mt = 0;
          ml = self.img.left;
        } else {
          mt = self.img.top;
          ml = self.img.left;
        }
        $(".thumb-list").eq(self.num.menu).append('<a href="'+anchor+'" data-transition="slide"><img src="../include/img-portfolio.thumb.php?dir='+self.menu.dir+'&amp;file='+i+'&amp;size='+cfg.thumb_size+'&amp;wtrim='+cfg.thumb_w+'&amp;htrim='+cfg.thumb_h+'" alt="'+self.menu.dir+'" style="margin-top:'+mt+'px;margin-left:'+ml+'px;" class="thumb-image file'+self.num.menu+'-'+i+'" /></a>');
        $(".file"+self.num.menu+"-"+i).bind("load", function() {
          num++;
          var per = Math.floor((num/self.num.total)*200);
          $(".loading-bar").eq(self.num.menu).find("span").css({width:per+"px"});
          $(".loading-txt").eq(self.num.menu).html("Now Loading<br />"+num +"/"+ self.num.total);
          if(num == (self.num.total)){
            setTimeout( function() {
              $(".thumb-loading").eq(self.num.menu).fadeOut(cfg.img_fade, function() {
                $(".thumb-loading").eq(self.num.menu).css({display: "none"});
                setTimeout( function() {
                  $(".thumb-list").eq(self.num.menu).fadeIn(cfg.img_fade).addClass("loaded");
                   self.thumbClick();
                   self.pagerClick();
                }, 750);
              });
            }, 750);
          }
        });
      });
    },

    // サムネイル：クリックイベント
    thumbClick : function(){
      var self = this;
      $(".thumb-list").eq(self.num.menu).find("a").each(function(i){
        $(this).click(function(){
          self.imgLoading(self.num.menu,i);
        });
      });
    },

    // ページャ：クリックイベント
    pagerClick : function(){
      var self = this;
      var node  = $("directory",self.xml).eq(self.num.menu);
      var total = node.children("files").find("item").length;
      // Prev
      $(".main-list").eq(self.num.menu).find(".main-prev").each(function(i){
        $(this).click(function(){
          if(i >= 0) {
            var num = i - 1;
            self.imgLoading(self.num.menu,num);
          }
        });
      });
      // Next
      $(".main-list").eq(self.num.menu).find(".main-next").each(function(i){
        $(this).click(function(){
          if(i < total) {
            var num = i + 1;
            self.imgLoading(self.num.menu,num);
          }
        });
      });
    },

    // イメージ：ローディング
    imgLoading : function(i,j){
      var self = this;
      setTimeout( function() {
        var node = $("directory",self.xml).eq(i);
        var path = node.find("item").eq(j).find("path").text();
        var name = node.find("item").eq(j).find("name").text();
        var width  = node.find("item").eq(j).find("width").text();
        var height = node.find("item").eq(j).find("height").text();
        var main = $(".main-list").eq(i).find(".main-image").eq(j);
        var winw = main.find(".image-data").width();
        var imgw = (winw < width)? winw: width;
        var flg  = main.find(".image-data > img").hasClass("data"+i+"-"+j);
        if(!flg){
          main.find(".image-data").html('<img src="../'+path+'" width="'+imgw+'" alt="'+name+'" class="data'+i+'-'+j+'" />');
          //main.find(".image-data").html('<img src="'+path+'" width="'+imgw+'" alt="'+name+'" class="data'+i+'-'+j+'" />');
          $(".data"+i+"-"+j).bind("load", function() {
            main.find(".image-loading").fadeOut(cfg.img_fade, function() {
              main.find(".image-data > img").fadeIn(cfg.img_fade);
            });
          });
        }
      }, 750);
    },

    // リンクを無効化する
    clickHandler : function(e){
      if(e.preventDefault){
        e.preventDefault();
      } else if(window.event){
        window.event.returnValue = false;
      }
    },

    // 表示する画像のサイズを計算
    getSizeImage : function(w,h,wNew,hNew) {
      var self = this;
      var flg;
      var calWidth;
      var calHeight;
      if(w > h){
        flg = (w >= wNew)? wNew: w;
        self.img.width   = flg;
        calHeight = h / w;
        self.img.height  = Math.floor(self.img.width * calHeight);
        self.img.top    = Math.floor((hNew - self.img.height)/2);
        self.img.left   = Math.floor((wNew - self.img.width)/2);
        if(self.img.height > hNew){
          self.img.height = hNew;
          calWidth  = w / h;
          self.img.width  = Math.floor(self.img.height * calWidth);
          self.img.top   = Math.floor((hNew - self.img.height)/2);
          self.img.left  = Math.floor((wNew - self.img.width)/2);
        }
      } else {
        flg = (h >= hNew)? hNew: h;
        self.img.height  = flg;
        calWidth  = w / h;
        self.img.width   = Math.floor(self.img.height * calWidth);
        self.img.top    = Math.floor((hNew - self.img.height)/2);
        self.img.left   = Math.floor((wNew  - self.img.width)/2);
        if(self.img.width > wNew){
          self.img.width  = wNew;
          calHeight = h / w;
          self.img.height = Math.floor(self.img.width * calHeight);
          self.img.top   = Math.floor((hNew - self.img.height)/2);
          self.img.left  = Math.floor((wNew  - self.img.width)/2);
        }
      }
    }
  }

  return new eventComponent();

}

})(jQuery);