<?php 

class theme_tmpl {
  var $config = array();
  var $theme  = array();

  function theme_tmpl($value1, $value2) {
    $this->config = $value1;
    $this->theme  = $value2;
  }

  public function path() {
    $html  = "";
    $html .= $this->config["path"];
    $this->path = $html;
    echo $this->path;
  }

  public function head() {
    $html  = "";
    $html .= "<title>".$this->config["site_name"]."</title>"."\n"."\n";
    if($this->config["site_description"] !== "") {
      $desc  = ereg_replace("\r|\n","",$this->config["site_description"]);
      $html .= '<meta name="description" content="'.$desc.'" />'."\n";
    }
    if($this->config["site_keyword"] !== "") {
      $html .= '<meta name="keywords" content="'.$this->config["site_keyword"].'" />'."\n";
    }
    if($this->config["site_robots"] == true) {
      $html .= '<meta name="robots" content="noindex,nofollow" />'."\n";
    }
    $this->head = $html;
    echo $this->head;
  }

  public function site_name() {
    $html  = "";
    $html .= $this->config["site_name"];
    $this->site_name = $html;
    echo $this->site_name;
  }

  public function menu() {
    $html  = "";
    foreach ($this->config["data"] as $key => $dir){
      $html .= '      <li>' .'<a href="#'.$dir["dir"].'/list" data-transition="slide" class="menu-list">'.$dir["name"].'</a></li>'."\n";
    }
    $this->menu = $html;
    echo $this->menu;
  }

  public function thumb() {
    $html =  '';
    foreach ($this->config["data"] as $d => $dir) {
      $html .= '  <section data-role="page" id="'.$dir["dir"].'/list" class="thumb-data" data-theme="b">'."\n";
      $html .= '    <header data-role="header" data-position="inline">'."\n";
      $html .= '      <a href="#top" data-icon="arrow-l" data-direction="reverse">Menu</a>'."\n";
      $html .= '      <h1>'.$dir["name"].'</h1>'."\n";
      $html .= '    </header>'."\n";
      $html .= '    <nav class="thumb-loading">'."\n";
      $html .= '      <p class="loading-bar"><span>&nbsp;</span></p>'."\n";
      $html .= '      <p class="loading-txt">Now Loading</p>'."\n";
      $html .= '    </nav>'."\n";
      $html .= '    <article data-role="content" class="thumb-list">'."\n";
      $html .= '    </article>'."\n";
      $html .= '    <br class="clear">'."\n";
      $html .= '  </section>'."\n";
    }
    $this->thumb = $html;
    echo $this->thumb;
  }

  public function main() {
    $html =  '';
    foreach ($this->config["data"] as $d => $dir) {
      $html .= '  <div class="main-list">'."\n";
      foreach ($dir["file"] as $f => $file) {
        $html .= '    <section data-role="page" id="'.$dir["dir"].'/'.$file["name"].'" class="main-data" data-theme="b">'."\n";
        $html .= '      <header data-role="header" data-position="inline" data-position="fixed">'."\n";
        $html .= '        <a href="#'.$dir["dir"].'/list" data-icon="arrow-l" data-direction="reverse">List</a>'."\n";
        $html .= '        <h1>'.$file["name"].'</h1>'."\n";
        $html .= '      </header>'."\n";
        $html .= '      <article data-role="content" class="main-image">'."\n";
        $html .= '        <dl>'."\n";
        $html .= '          <dt>'.$file["name"].'</dt>'."\n";
        $html .= '          <dd class="image-loading"><p><img src="'.$this->config["path"].'common/main-loader.png" alt="" width="35" height="35" class="loading" /></p></dd>'."\n";
        $html .= '          <dd class="image-data">&nbsp;</dd>'."\n";
        $html .= '          <dd class="image-body">'.nl2br($file["body"]).'</dd>'."\n";
        $html .= '        </dl>'."\n";
        $html .= '      </article>'."\n";
        $html .= '      <nav data-role="controlgroup" data-type="horizontal">'."\n";
        $html .= '        <a href="#'.$dir["dir"].'/'.($dir["file"][(int)$f-1]["name"]).'" data-role="button" data-icon="arrow-l" data-direction="reverse" class="main-prev">Prev</a>'."\n";
        $html .= '        <a href="#'.$dir["dir"].'/list" data-role="button" data-direction="reverse">'.((int)$f+1).'/'.count($dir["file"]).'</span>'."\n";
        $html .= '        <a href="#'.$dir["dir"].'/'.($dir["file"][(int)$f+1]["name"]).'" data-role="button" data-icon="arrow-r" class="main-next">Next</a>'."\n";
        $html .= '      </nav>'."\n";
        $html .= '    </section>'."\n";
      }
      $html .= '  </div>'."\n";
    }
    $this->main = $html;
    echo $this->main;
  }

  public function prof_disp() {
    $flg  = ($this->config["prof_disp"] !== "" && $this->config["prof_disp"] == 1)? true: false;
    $this->prof_disp = $flg;
    return $this->prof_disp;
  }

  public function prof_name() {
    if($this->config["prof_name"] !== "") {
      $html  = "";
      $html .= $this->config["prof_name"];
      $this->prof_name = $html;
      echo $this->prof_name;
    }
  }

  public function prof_mail() {
    if($this->config["mail_name"] !== "" && $this->config["mail_disp"] == 1) {
      $html  = "";
      $html .= '        <p class="mail">'.'<a href="mailto:' .$this->config["mail_name"].'">'.$this->config["mail_name"].'</a>'.'</p>'."\n";
      $this->prof_mail = $html;
      echo $this->prof_mail;
    }
  }

  public function prof_description() {
    if($this->config["prof_description"] !== "") {
      $html  = "";
      $html .= '        <div class="description">'."\n".nl2br($this->config["prof_description"])."\n".'</div>'."\n";
      $this->prof_description = $html;
      echo $this->prof_description;
    }
  }

  public function prof_image() {
    if($this->config["prof_image"] !== "") {
      $html  = "";
      $html .= '        <p class="photo">'.'<img src="'.$this->config["prof_image"].'" alt="profile image" width="150" height="150" />'.'</p>'."\n";
      $this->prof_image = $html;
      echo $this->prof_image;
    }
  }

  public function prof_lnk() {
    $html  = "";
    if($this->config["lnk_twttr"] !== "") {
      $html .= '          <li><a href="http://twitter.com/' .$this->config["lnk_twttr"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-twitter.png" width="32" height="32" alt="" /></a></li>'."\n";
    }
    if($this->config["lnk_facebook"] !== "") {
      $html .= '          <li><a href="http://www.facebook.com/' .$this->config["lnk_facebook"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-facebook.png" width="32" height="32" alt="" /></a></li>'."\n";
    }
    if($this->config["lnk_mixi"] !== "") {
      $html .= '          <li><a href="http://mixi.jp/show_friend.pl?id=' .$this->config["lnk_mixi"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-mixi.png" width="32" height="32" alt="" /></a></li>'."\n";
    }
    if($this->config["lnk_blog"] !== "") {
      $html .= '          <li><a href="'.$this->config["lnk_blog"].'" target="_blank"><img src="'.$this->config["path"].'common/icon-blog.png" width="32" height="32" alt="" /></a></li>'."\n";
    }
    if($html !== "") {
      $html  = '        <ul>'."\n".$html.'        </ul>'."\n";
      $this->prof_lnk = $html;
      echo $this->prof_lnk;
    }
  }

  public function copy() {
    if($this->config["site_copy"] !== "") {
      $html  = "";
      $html .= '    <address>'.$this->config["site_copy"].'</address>'."\n";
      $this->copy = $html;
      echo $this->copy;
    }
  }

}

?>